/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.invocation;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.metrics.core.meter.invocation.ConsumerInvocationMeter;

public class EdgeInvocationMeter
extends ConsumerInvocationMeter {
    private final Timer providerDecodeRequestTimer;
    private final Timer providerEncodeResponseTimer;
    private final Timer sendResponseTimer;

    public EdgeInvocationMeter(MeterRegistry meterRegistry, String name, Tags tags, MetricsBootstrapConfig metricsBootstrapConfig) {
        super(meterRegistry, name, tags, metricsBootstrapConfig);
        this.providerDecodeRequestTimer = Timer.builder((String)name).tags((Iterable)tags.and(new String[]{"type", "stage", "stage", "provider-decode"})).register(meterRegistry);
        this.providerEncodeResponseTimer = Timer.builder((String)name).tags((Iterable)tags.and(new String[]{"type", "stage", "stage", "provider-encode"})).register(meterRegistry);
        this.sendResponseTimer = Timer.builder((String)name).tags((Iterable)tags.and(new String[]{"type", "stage", "stage", "provider-send"})).register(meterRegistry);
    }

    @Override
    public void onInvocationFinish(InvocationFinishEvent event) {
        super.onInvocationFinish(event);
        InvocationStageTrace invocationStageTrace = event.getInvocation().getInvocationStageTrace();
        this.providerDecodeRequestTimer.record(invocationStageTrace.calcProviderDecodeRequest(), TimeUnit.NANOSECONDS);
        this.providerEncodeResponseTimer.record(invocationStageTrace.calcProviderEncodeResponse(), TimeUnit.NANOSECONDS);
        this.sendResponseTimer.record(invocationStageTrace.calcProviderSendResponse(), TimeUnit.NANOSECONDS);
    }
}

