/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.CountingMode;
import java.time.Duration;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrap;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.metrics.core.InvocationMetersInitializer;
import org.apache.servicecomb.metrics.core.MetricsBootListener;
import org.apache.servicecomb.metrics.core.OsMetersInitializer;
import org.apache.servicecomb.metrics.core.SimpleMeterRegistryExt;
import org.apache.servicecomb.metrics.core.ThreadPoolMetersInitializer;
import org.apache.servicecomb.metrics.core.VertxMetersInitializer;
import org.apache.servicecomb.metrics.core.publish.DefaultLogPublisher;
import org.apache.servicecomb.metrics.core.publish.SlowInvocationLogger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class MetricsCoreConfiguration {
    @Bean
    public MetricsBootstrapConfig metricsBootstrapConfig(Environment environment) {
        return new MetricsBootstrapConfig(environment);
    }

    @Bean
    @ConditionalOnMissingBean
    public MeterRegistry meterRegistry(MetricsBootstrapConfig config) {
        return new SimpleMeterRegistryExt(s -> {
            if ("simple.step".equals(s)) {
                return Duration.ofMillis(config.getMsPollInterval()).toString();
            }
            if ("simple.mode".equals(s)) {
                return CountingMode.STEP.name();
            }
            return null;
        }, Clock.SYSTEM);
    }

    @Bean
    public MetricsBootListener metricsBootListener(MetricsBootstrap metricsBootstrap) {
        return new MetricsBootListener(metricsBootstrap);
    }

    @Bean
    public MetricsBootstrap metricsBootstrap(MetricsBootstrapConfig config) {
        return new MetricsBootstrap(config);
    }

    @Bean
    public DefaultLogPublisher defaultLogPublisher() {
        return new DefaultLogPublisher();
    }

    @Bean
    public InvocationMetersInitializer invocationMetersInitializer() {
        return new InvocationMetersInitializer();
    }

    @Bean
    public ThreadPoolMetersInitializer threadPoolMetersInitializer() {
        return new ThreadPoolMetersInitializer();
    }

    @Bean
    public VertxMetersInitializer vertxMetersInitializer() {
        return new VertxMetersInitializer();
    }

    @Bean
    public OsMetersInitializer osMetersInitializer() {
        return new OsMetersInitializer();
    }

    @Bean
    public SlowInvocationLogger slowInvocationLogger(SCBEngine scbEngine) {
        return new SlowInvocationLogger(scbEngine);
    }
}

