/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.springmvc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.ParameterGenerator;
import org.apache.servicecomb.swagger.generator.core.AbstractSwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;
import org.apache.servicecomb.swagger.generator.rest.RestOperationGenerator;
import org.springframework.web.bind.annotation.RequestBody;

public class SpringmvcOperationGenerator
extends RestOperationGenerator {
    public SpringmvcOperationGenerator(AbstractSwaggerGenerator swaggerGenerator, Method method) {
        super(swaggerGenerator, method);
    }

    protected void initMethodParameterGenerators(Map<String, List<Annotation>> methodAnnotationMap) {
        super.initMethodParameterGenerators(methodAnnotationMap);
        this.parameterGenerators.stream().filter(pg -> pg.getHttpParameterType() == null).forEach(pg -> pg.setHttpParameterType(HttpParameterType.QUERY));
    }

    protected boolean isAggregatedParameter(ParameterGenerator parameterGenerator, Parameter methodParameter) {
        return !this.isRequestBody(parameterGenerator) && SwaggerUtils.isBean((Type)methodParameter.getParameterizedType());
    }

    private boolean isRequestBody(ParameterGenerator parameterGenerator) {
        for (Annotation annotation : parameterGenerator.getAnnotations()) {
            if (annotation.annotationType() != RequestBody.class) continue;
            return true;
        }
        return false;
    }
}

