/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class LldpManagementAddressTxPortType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 18955;
  }

  // Properties.
  protected final long addressSubtype;
  protected final PascalString manAddress;
  protected final boolean txEnable;
  protected final long addrLen;
  protected final ManAddrIfSubtype ifSubtype;
  protected final long ifId;

  public LldpManagementAddressTxPortType(
      long addressSubtype,
      PascalString manAddress,
      boolean txEnable,
      long addrLen,
      ManAddrIfSubtype ifSubtype,
      long ifId) {
    super();
    this.addressSubtype = addressSubtype;
    this.manAddress = manAddress;
    this.txEnable = txEnable;
    this.addrLen = addrLen;
    this.ifSubtype = ifSubtype;
    this.ifId = ifId;
  }

  public long getAddressSubtype() {
    return addressSubtype;
  }

  public PascalString getManAddress() {
    return manAddress;
  }

  public boolean getTxEnable() {
    return txEnable;
  }

  public long getAddrLen() {
    return addrLen;
  }

  public ManAddrIfSubtype getIfSubtype() {
    return ifSubtype;
  }

  public long getIfId() {
    return ifId;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("LldpManagementAddressTxPortType");

    // Simple Field (addressSubtype)
    writeSimpleField("addressSubtype", addressSubtype, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (manAddress)
    writeSimpleField("manAddress", manAddress, writeComplex(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (txEnable)
    writeSimpleField("txEnable", txEnable, writeBoolean(writeBuffer));

    // Simple Field (addrLen)
    writeSimpleField("addrLen", addrLen, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (ifSubtype)
    writeSimpleEnumField(
        "ifSubtype",
        "ManAddrIfSubtype",
        ifSubtype,
        writeEnum(
            ManAddrIfSubtype::getValue,
            ManAddrIfSubtype::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (ifId)
    writeSimpleField("ifId", ifId, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("LldpManagementAddressTxPortType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    LldpManagementAddressTxPortType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (addressSubtype)
    lengthInBits += 32;

    // Simple field (manAddress)
    lengthInBits += manAddress.getLengthInBits();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (txEnable)
    lengthInBits += 1;

    // Simple field (addrLen)
    lengthInBits += 32;

    // Simple field (ifSubtype)
    lengthInBits += 32;

    // Simple field (ifId)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("LldpManagementAddressTxPortType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long addressSubtype = readSimpleField("addressSubtype", readUnsignedLong(readBuffer, 32));

    PascalString manAddress =
        readSimpleField(
            "manAddress", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean txEnable = readSimpleField("txEnable", readBoolean(readBuffer));

    long addrLen = readSimpleField("addrLen", readUnsignedLong(readBuffer, 32));

    ManAddrIfSubtype ifSubtype =
        readEnumField(
            "ifSubtype",
            "ManAddrIfSubtype",
            readEnum(ManAddrIfSubtype::enumForValue, readUnsignedLong(readBuffer, 32)));

    long ifId = readSimpleField("ifId", readUnsignedLong(readBuffer, 32));

    readBuffer.closeContext("LldpManagementAddressTxPortType");
    // Create the instance
    return new LldpManagementAddressTxPortTypeBuilderImpl(
        addressSubtype, manAddress, txEnable, addrLen, ifSubtype, ifId);
  }

  public static class LldpManagementAddressTxPortTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final long addressSubtype;
    private final PascalString manAddress;
    private final boolean txEnable;
    private final long addrLen;
    private final ManAddrIfSubtype ifSubtype;
    private final long ifId;

    public LldpManagementAddressTxPortTypeBuilderImpl(
        long addressSubtype,
        PascalString manAddress,
        boolean txEnable,
        long addrLen,
        ManAddrIfSubtype ifSubtype,
        long ifId) {
      this.addressSubtype = addressSubtype;
      this.manAddress = manAddress;
      this.txEnable = txEnable;
      this.addrLen = addrLen;
      this.ifSubtype = ifSubtype;
      this.ifId = ifId;
    }

    public LldpManagementAddressTxPortType build() {
      LldpManagementAddressTxPortType lldpManagementAddressTxPortType =
          new LldpManagementAddressTxPortType(
              addressSubtype, manAddress, txEnable, addrLen, ifSubtype, ifId);
      return lldpManagementAddressTxPortType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof LldpManagementAddressTxPortType)) {
      return false;
    }
    LldpManagementAddressTxPortType that = (LldpManagementAddressTxPortType) o;
    return (getAddressSubtype() == that.getAddressSubtype())
        && (getManAddress() == that.getManAddress())
        && (getTxEnable() == that.getTxEnable())
        && (getAddrLen() == that.getAddrLen())
        && (getIfSubtype() == that.getIfSubtype())
        && (getIfId() == that.getIfId())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getAddressSubtype(),
        getManAddress(),
        getTxEnable(),
        getAddrLen(),
        getIfSubtype(),
        getIfId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
