/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.canopen.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SDOSegment implements Message {

  // Properties.
  protected final boolean expedited;
  protected final boolean indicated;
  protected final IndexAddress address;
  protected final byte[] data;

  public SDOSegment(boolean expedited, boolean indicated, IndexAddress address, byte[] data) {
    super();
    this.expedited = expedited;
    this.indicated = indicated;
    this.address = address;
    this.data = data;
  }

  public boolean getExpedited() {
    return expedited;
  }

  public boolean getIndicated() {
    return indicated;
  }

  public IndexAddress getAddress() {
    return address;
  }

  public byte[] getData() {
    return data;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SDOSegment");

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 1));

    // Implicit Field (size) (Used for parsing, but its value is not stored as it's implicitly given
    // by the objects content)
    byte size = (byte) ((((getExpedited()) && (getIndicated())) ? (4) - (COUNT(getData())) : 0));
    writeImplicitField("size", size, writeUnsignedByte(writeBuffer, 2));

    // Simple Field (expedited)
    writeSimpleField("expedited", expedited, writeBoolean(writeBuffer));

    // Simple Field (indicated)
    writeSimpleField("indicated", indicated, writeBoolean(writeBuffer));

    // Simple Field (address)
    writeSimpleField("address", address, writeComplex(writeBuffer));

    // Array Field (data)
    writeByteArrayField("data", data, writeByteArray(writeBuffer, 8));

    // Padding Field (padding)
    writePaddingField(
        "padding", (int) ((4) - ((COUNT(data)))), (short) 0x00, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("SDOSegment");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    SDOSegment _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Implicit Field (size)
    lengthInBits += 2;

    // Simple field (expedited)
    lengthInBits += 1;

    // Simple field (indicated)
    lengthInBits += 1;

    // Simple field (address)
    lengthInBits += address.getLengthInBits();

    // Array field
    if (data != null) {
      lengthInBits += 8 * data.length;
    }

    // Padding Field (padding)
    int _timesPadding = (int) ((4) - ((COUNT(data))));
    while (_timesPadding-- > 0) {
      lengthInBits += 8;
    }

    return lengthInBits;
  }

  public static SDOSegment staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("SDOSegment");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 1), (byte) 0x00);

    byte size = readImplicitField("size", readUnsignedByte(readBuffer, 2));

    boolean expedited = readSimpleField("expedited", readBoolean(readBuffer));

    boolean indicated = readSimpleField("indicated", readBoolean(readBuffer));

    IndexAddress address =
        readSimpleField(
            "address", readComplex(() -> IndexAddress.staticParse(readBuffer), readBuffer));

    byte[] data =
        readBuffer.readByteArray(
            "data", Math.toIntExact(((((expedited) && (indicated))) ? (4) - (size) : 0)));

    readPaddingField(readUnsignedShort(readBuffer, 8), (int) ((4) - ((COUNT(data)))));

    readBuffer.closeContext("SDOSegment");
    // Create the instance
    SDOSegment _sDOSegment;
    _sDOSegment = new SDOSegment(expedited, indicated, address, data);
    return _sDOSegment;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SDOSegment)) {
      return false;
    }
    SDOSegment that = (SDOSegment) o;
    return (getExpedited() == that.getExpedited())
        && (getIndicated() == that.getIndicated())
        && (getAddress() == that.getAddress())
        && (getData() == that.getData())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getExpedited(), getIndicated(), getAddress(), getData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
