/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble is the corresponding interface of BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble
type BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetFaultParameterFaultOutOfRangeMinNormalValue
	// GetDoubleValue returns DoubleValue (property field)
	GetDoubleValue() BACnetApplicationTagDouble
	// IsBACnetFaultParameterFaultOutOfRangeMinNormalValueDouble is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetFaultParameterFaultOutOfRangeMinNormalValueDouble()
	// CreateBuilder creates a BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder
	CreateBACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder() BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder
}

// _BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble is the data-structure of this message
type _BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble struct {
	BACnetFaultParameterFaultOutOfRangeMinNormalValueContract
	DoubleValue BACnetApplicationTagDouble
}

var _ BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble = (*_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble)(nil)
var _ BACnetFaultParameterFaultOutOfRangeMinNormalValueRequirements = (*_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble)(nil)

// NewBACnetFaultParameterFaultOutOfRangeMinNormalValueDouble factory function for _BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble
func NewBACnetFaultParameterFaultOutOfRangeMinNormalValueDouble(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, doubleValue BACnetApplicationTagDouble, tagNumber uint8) *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble {
	if doubleValue == nil {
		panic("doubleValue of type BACnetApplicationTagDouble for BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble must not be nil")
	}
	_result := &_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble{
		BACnetFaultParameterFaultOutOfRangeMinNormalValueContract: NewBACnetFaultParameterFaultOutOfRangeMinNormalValue(openingTag, peekedTagHeader, closingTag, tagNumber),
		DoubleValue: doubleValue,
	}
	_result.BACnetFaultParameterFaultOutOfRangeMinNormalValueContract.(*_BACnetFaultParameterFaultOutOfRangeMinNormalValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder is a builder for BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble
type BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(doubleValue BACnetApplicationTagDouble) BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder
	// WithDoubleValue adds DoubleValue (property field)
	WithDoubleValue(BACnetApplicationTagDouble) BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder
	// WithDoubleValueBuilder adds DoubleValue (property field) which is build by the builder
	WithDoubleValueBuilder(func(BACnetApplicationTagDoubleBuilder) BACnetApplicationTagDoubleBuilder) BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder
	// Build builds the BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble or returns an error if something is wrong
	Build() (BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble
}

// NewBACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder() creates a BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder
func NewBACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder() BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder {
	return &_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder{_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble: new(_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble)}
}

type _BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder struct {
	*_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble

	parentBuilder *_BACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder

	collectedErr []error
}

var _ (BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder) = (*_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder)(nil)

func (b *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder) setParent(contract BACnetFaultParameterFaultOutOfRangeMinNormalValueContract) {
	b.BACnetFaultParameterFaultOutOfRangeMinNormalValueContract = contract
	contract.(*_BACnetFaultParameterFaultOutOfRangeMinNormalValue)._SubType = b._BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble
}

func (b *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder) WithMandatoryFields(doubleValue BACnetApplicationTagDouble) BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder {
	return b.WithDoubleValue(doubleValue)
}

func (b *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder) WithDoubleValue(doubleValue BACnetApplicationTagDouble) BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder {
	b.DoubleValue = doubleValue
	return b
}

func (b *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder) WithDoubleValueBuilder(builderSupplier func(BACnetApplicationTagDoubleBuilder) BACnetApplicationTagDoubleBuilder) BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder {
	builder := builderSupplier(b.DoubleValue.CreateBACnetApplicationTagDoubleBuilder())
	var err error
	b.DoubleValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagDoubleBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder) Build() (BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble, error) {
	if b.DoubleValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'doubleValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble.deepCopy(), nil
}

func (b *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder) MustBuild() BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder) Done() BACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder().(*_BACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder) buildForBACnetFaultParameterFaultOutOfRangeMinNormalValue() (BACnetFaultParameterFaultOutOfRangeMinNormalValue, error) {
	return b.Build()
}

func (b *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder) DeepCopy() any {
	_copy := b.CreateBACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder().(*_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder creates a BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder
func (b *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) CreateBACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder() BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder {
	if b == nil {
		return NewBACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder()
	}
	return &_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleBuilder{_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) GetParent() BACnetFaultParameterFaultOutOfRangeMinNormalValueContract {
	return m.BACnetFaultParameterFaultOutOfRangeMinNormalValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) GetDoubleValue() BACnetApplicationTagDouble {
	return m.DoubleValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetFaultParameterFaultOutOfRangeMinNormalValueDouble(structType any) BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble {
	if casted, ok := structType.(BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) GetTypeName() string {
	return "BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble"
}

func (m *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetFaultParameterFaultOutOfRangeMinNormalValueContract.(*_BACnetFaultParameterFaultOutOfRangeMinNormalValue).getLengthInBits(ctx))

	// Simple field (doubleValue)
	lengthInBits += m.DoubleValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetFaultParameterFaultOutOfRangeMinNormalValue, tagNumber uint8) (__bACnetFaultParameterFaultOutOfRangeMinNormalValueDouble BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble, err error) {
	m.BACnetFaultParameterFaultOutOfRangeMinNormalValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	doubleValue, err := ReadSimpleField[BACnetApplicationTagDouble](ctx, "doubleValue", ReadComplex[BACnetApplicationTagDouble](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagDouble](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'doubleValue' field"))
	}
	m.DoubleValue = doubleValue

	if closeErr := readBuffer.CloseContext("BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble")
	}

	return m, nil
}

func (m *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble")
		}

		if err := WriteSimpleField[BACnetApplicationTagDouble](ctx, "doubleValue", m.GetDoubleValue(), WriteComplex[BACnetApplicationTagDouble](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'doubleValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble")
		}
		return nil
	}
	return m.BACnetFaultParameterFaultOutOfRangeMinNormalValueContract.(*_BACnetFaultParameterFaultOutOfRangeMinNormalValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) IsBACnetFaultParameterFaultOutOfRangeMinNormalValueDouble() {
}

func (m *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) deepCopy() *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble {
	if m == nil {
		return nil
	}
	_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleCopy := &_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble{
		m.BACnetFaultParameterFaultOutOfRangeMinNormalValueContract.(*_BACnetFaultParameterFaultOutOfRangeMinNormalValue).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagDouble](m.DoubleValue),
	}
	_BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleCopy.BACnetFaultParameterFaultOutOfRangeMinNormalValueContract.(*_BACnetFaultParameterFaultOutOfRangeMinNormalValue)._SubType = m
	return _BACnetFaultParameterFaultOutOfRangeMinNormalValueDoubleCopy
}

func (m *_BACnetFaultParameterFaultOutOfRangeMinNormalValueDouble) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
