/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class ExtensionObjectWithMask extends ExtensionObject implements Message {

  // Accessors for discriminator values.
  public Boolean getIncludeEncodingMask() {
    return (boolean) true;
  }

  // Abstract accessors for discriminator values.
  public abstract Boolean getEncodingMaskBinaryBody();

  public abstract Boolean getEncodingMaskXmlBody();

  // Properties.
  protected final ExtensionObjectEncodingMask encodingMask;

  public ExtensionObjectWithMask(ExpandedNodeId typeId, ExtensionObjectEncodingMask encodingMask) {
    super(typeId);
    this.encodingMask = encodingMask;
  }

  public ExtensionObjectEncodingMask getEncodingMask() {
    return encodingMask;
  }

  protected abstract void serializeExtensionObjectWithMaskChild(WriteBuffer writeBuffer)
      throws SerializationException;

  @Override
  protected void serializeExtensionObjectChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ExtensionObjectWithMask");

    // Simple Field (encodingMask)
    writeSimpleField("encodingMask", encodingMask, writeComplex(writeBuffer));

    // Switch field (Serialize the sub-type)
    serializeExtensionObjectWithMaskChild(writeBuffer);

    writeBuffer.popContext("ExtensionObjectWithMask");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ExtensionObjectWithMask _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (encodingMask)
    lengthInBits += encodingMask.getLengthInBits();

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static ExtensionObjectBuilder staticParseExtensionObjectBuilder(
      ReadBuffer readBuffer, Integer extensionId, Boolean includeEncodingMask)
      throws ParseException {
    readBuffer.pullContext("ExtensionObjectWithMask");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ExtensionObjectEncodingMask encodingMask =
        readSimpleField(
            "encodingMask",
            readComplex(() -> ExtensionObjectEncodingMask.staticParse(readBuffer), readBuffer));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    ExtensionObjectWithMaskBuilder builder = null;
    if (EvaluationHelper.equals(encodingMask.getXmlBody(), (boolean) false)
        && EvaluationHelper.equals(encodingMask.getBinaryBody(), (boolean) true)) {
      builder =
          BinaryExtensionObjectWithMask.staticParseExtensionObjectWithMaskBuilder(
              readBuffer, extensionId, includeEncodingMask);
    } else if (EvaluationHelper.equals(encodingMask.getXmlBody(), (boolean) false)
        && EvaluationHelper.equals(encodingMask.getBinaryBody(), (boolean) false)) {
      builder =
          NullExtensionObjectWithMask.staticParseExtensionObjectWithMaskBuilder(
              readBuffer, extensionId, includeEncodingMask);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "encodingMaskxmlBody="
              + encodingMask.getXmlBody()
              + " "
              + "encodingMaskbinaryBody="
              + encodingMask.getBinaryBody()
              + "]");
    }

    readBuffer.closeContext("ExtensionObjectWithMask");
    // Create the instance
    return new ExtensionObjectWithMaskBuilderImpl(encodingMask, builder);
  }

  public interface ExtensionObjectWithMaskBuilder {
    ExtensionObjectWithMask build(ExpandedNodeId typeId, ExtensionObjectEncodingMask encodingMask);
  }

  public static class ExtensionObjectWithMaskBuilderImpl
      implements ExtensionObject.ExtensionObjectBuilder {
    private final ExtensionObjectEncodingMask encodingMask;
    private final ExtensionObjectWithMaskBuilder builder;

    public ExtensionObjectWithMaskBuilderImpl(
        ExtensionObjectEncodingMask encodingMask, ExtensionObjectWithMaskBuilder builder) {
      this.encodingMask = encodingMask;
      this.builder = builder;
    }

    public ExtensionObjectWithMask build(ExpandedNodeId typeId) {
      return builder.build(typeId, encodingMask);
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ExtensionObjectWithMask)) {
      return false;
    }
    ExtensionObjectWithMask that = (ExtensionObjectWithMask) o;
    return (getEncodingMask() == that.getEncodingMask()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getEncodingMask());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
