/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// RegisteredServer is the corresponding interface of RegisteredServer
type RegisteredServer interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetServerUri returns ServerUri (property field)
	GetServerUri() PascalString
	// GetProductUri returns ProductUri (property field)
	GetProductUri() PascalString
	// GetServerNames returns ServerNames (property field)
	GetServerNames() []LocalizedText
	// GetServerType returns ServerType (property field)
	GetServerType() ApplicationType
	// GetGatewayServerUri returns GatewayServerUri (property field)
	GetGatewayServerUri() PascalString
	// GetDiscoveryUrls returns DiscoveryUrls (property field)
	GetDiscoveryUrls() []PascalString
	// GetSemaphoreFilePath returns SemaphoreFilePath (property field)
	GetSemaphoreFilePath() PascalString
	// GetIsOnline returns IsOnline (property field)
	GetIsOnline() bool
	// IsRegisteredServer is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsRegisteredServer()
	// CreateBuilder creates a RegisteredServerBuilder
	CreateRegisteredServerBuilder() RegisteredServerBuilder
}

// _RegisteredServer is the data-structure of this message
type _RegisteredServer struct {
	ExtensionObjectDefinitionContract
	ServerUri         PascalString
	ProductUri        PascalString
	ServerNames       []LocalizedText
	ServerType        ApplicationType
	GatewayServerUri  PascalString
	DiscoveryUrls     []PascalString
	SemaphoreFilePath PascalString
	IsOnline          bool
	// Reserved Fields
	reservedField0 *uint8
}

var _ RegisteredServer = (*_RegisteredServer)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_RegisteredServer)(nil)

// NewRegisteredServer factory function for _RegisteredServer
func NewRegisteredServer(serverUri PascalString, productUri PascalString, serverNames []LocalizedText, serverType ApplicationType, gatewayServerUri PascalString, discoveryUrls []PascalString, semaphoreFilePath PascalString, isOnline bool) *_RegisteredServer {
	if serverUri == nil {
		panic("serverUri of type PascalString for RegisteredServer must not be nil")
	}
	if productUri == nil {
		panic("productUri of type PascalString for RegisteredServer must not be nil")
	}
	if gatewayServerUri == nil {
		panic("gatewayServerUri of type PascalString for RegisteredServer must not be nil")
	}
	if semaphoreFilePath == nil {
		panic("semaphoreFilePath of type PascalString for RegisteredServer must not be nil")
	}
	_result := &_RegisteredServer{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ServerUri:                         serverUri,
		ProductUri:                        productUri,
		ServerNames:                       serverNames,
		ServerType:                        serverType,
		GatewayServerUri:                  gatewayServerUri,
		DiscoveryUrls:                     discoveryUrls,
		SemaphoreFilePath:                 semaphoreFilePath,
		IsOnline:                          isOnline,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// RegisteredServerBuilder is a builder for RegisteredServer
type RegisteredServerBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(serverUri PascalString, productUri PascalString, serverNames []LocalizedText, serverType ApplicationType, gatewayServerUri PascalString, discoveryUrls []PascalString, semaphoreFilePath PascalString, isOnline bool) RegisteredServerBuilder
	// WithServerUri adds ServerUri (property field)
	WithServerUri(PascalString) RegisteredServerBuilder
	// WithServerUriBuilder adds ServerUri (property field) which is build by the builder
	WithServerUriBuilder(func(PascalStringBuilder) PascalStringBuilder) RegisteredServerBuilder
	// WithProductUri adds ProductUri (property field)
	WithProductUri(PascalString) RegisteredServerBuilder
	// WithProductUriBuilder adds ProductUri (property field) which is build by the builder
	WithProductUriBuilder(func(PascalStringBuilder) PascalStringBuilder) RegisteredServerBuilder
	// WithServerNames adds ServerNames (property field)
	WithServerNames(...LocalizedText) RegisteredServerBuilder
	// WithServerType adds ServerType (property field)
	WithServerType(ApplicationType) RegisteredServerBuilder
	// WithGatewayServerUri adds GatewayServerUri (property field)
	WithGatewayServerUri(PascalString) RegisteredServerBuilder
	// WithGatewayServerUriBuilder adds GatewayServerUri (property field) which is build by the builder
	WithGatewayServerUriBuilder(func(PascalStringBuilder) PascalStringBuilder) RegisteredServerBuilder
	// WithDiscoveryUrls adds DiscoveryUrls (property field)
	WithDiscoveryUrls(...PascalString) RegisteredServerBuilder
	// WithSemaphoreFilePath adds SemaphoreFilePath (property field)
	WithSemaphoreFilePath(PascalString) RegisteredServerBuilder
	// WithSemaphoreFilePathBuilder adds SemaphoreFilePath (property field) which is build by the builder
	WithSemaphoreFilePathBuilder(func(PascalStringBuilder) PascalStringBuilder) RegisteredServerBuilder
	// WithIsOnline adds IsOnline (property field)
	WithIsOnline(bool) RegisteredServerBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the RegisteredServer or returns an error if something is wrong
	Build() (RegisteredServer, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() RegisteredServer
}

// NewRegisteredServerBuilder() creates a RegisteredServerBuilder
func NewRegisteredServerBuilder() RegisteredServerBuilder {
	return &_RegisteredServerBuilder{_RegisteredServer: new(_RegisteredServer)}
}

type _RegisteredServerBuilder struct {
	*_RegisteredServer

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (RegisteredServerBuilder) = (*_RegisteredServerBuilder)(nil)

func (b *_RegisteredServerBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._RegisteredServer
}

func (b *_RegisteredServerBuilder) WithMandatoryFields(serverUri PascalString, productUri PascalString, serverNames []LocalizedText, serverType ApplicationType, gatewayServerUri PascalString, discoveryUrls []PascalString, semaphoreFilePath PascalString, isOnline bool) RegisteredServerBuilder {
	return b.WithServerUri(serverUri).WithProductUri(productUri).WithServerNames(serverNames...).WithServerType(serverType).WithGatewayServerUri(gatewayServerUri).WithDiscoveryUrls(discoveryUrls...).WithSemaphoreFilePath(semaphoreFilePath).WithIsOnline(isOnline)
}

func (b *_RegisteredServerBuilder) WithServerUri(serverUri PascalString) RegisteredServerBuilder {
	b.ServerUri = serverUri
	return b
}

func (b *_RegisteredServerBuilder) WithServerUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) RegisteredServerBuilder {
	builder := builderSupplier(b.ServerUri.CreatePascalStringBuilder())
	var err error
	b.ServerUri, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_RegisteredServerBuilder) WithProductUri(productUri PascalString) RegisteredServerBuilder {
	b.ProductUri = productUri
	return b
}

func (b *_RegisteredServerBuilder) WithProductUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) RegisteredServerBuilder {
	builder := builderSupplier(b.ProductUri.CreatePascalStringBuilder())
	var err error
	b.ProductUri, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_RegisteredServerBuilder) WithServerNames(serverNames ...LocalizedText) RegisteredServerBuilder {
	b.ServerNames = serverNames
	return b
}

func (b *_RegisteredServerBuilder) WithServerType(serverType ApplicationType) RegisteredServerBuilder {
	b.ServerType = serverType
	return b
}

func (b *_RegisteredServerBuilder) WithGatewayServerUri(gatewayServerUri PascalString) RegisteredServerBuilder {
	b.GatewayServerUri = gatewayServerUri
	return b
}

func (b *_RegisteredServerBuilder) WithGatewayServerUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) RegisteredServerBuilder {
	builder := builderSupplier(b.GatewayServerUri.CreatePascalStringBuilder())
	var err error
	b.GatewayServerUri, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_RegisteredServerBuilder) WithDiscoveryUrls(discoveryUrls ...PascalString) RegisteredServerBuilder {
	b.DiscoveryUrls = discoveryUrls
	return b
}

func (b *_RegisteredServerBuilder) WithSemaphoreFilePath(semaphoreFilePath PascalString) RegisteredServerBuilder {
	b.SemaphoreFilePath = semaphoreFilePath
	return b
}

func (b *_RegisteredServerBuilder) WithSemaphoreFilePathBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) RegisteredServerBuilder {
	builder := builderSupplier(b.SemaphoreFilePath.CreatePascalStringBuilder())
	var err error
	b.SemaphoreFilePath, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_RegisteredServerBuilder) WithIsOnline(isOnline bool) RegisteredServerBuilder {
	b.IsOnline = isOnline
	return b
}

func (b *_RegisteredServerBuilder) Build() (RegisteredServer, error) {
	if b.ServerUri == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'serverUri' not set"))
	}
	if b.ProductUri == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'productUri' not set"))
	}
	if b.GatewayServerUri == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'gatewayServerUri' not set"))
	}
	if b.SemaphoreFilePath == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'semaphoreFilePath' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._RegisteredServer.deepCopy(), nil
}

func (b *_RegisteredServerBuilder) MustBuild() RegisteredServer {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_RegisteredServerBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_RegisteredServerBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_RegisteredServerBuilder) DeepCopy() any {
	_copy := b.CreateRegisteredServerBuilder().(*_RegisteredServerBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateRegisteredServerBuilder creates a RegisteredServerBuilder
func (b *_RegisteredServer) CreateRegisteredServerBuilder() RegisteredServerBuilder {
	if b == nil {
		return NewRegisteredServerBuilder()
	}
	return &_RegisteredServerBuilder{_RegisteredServer: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_RegisteredServer) GetExtensionId() int32 {
	return int32(434)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_RegisteredServer) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_RegisteredServer) GetServerUri() PascalString {
	return m.ServerUri
}

func (m *_RegisteredServer) GetProductUri() PascalString {
	return m.ProductUri
}

func (m *_RegisteredServer) GetServerNames() []LocalizedText {
	return m.ServerNames
}

func (m *_RegisteredServer) GetServerType() ApplicationType {
	return m.ServerType
}

func (m *_RegisteredServer) GetGatewayServerUri() PascalString {
	return m.GatewayServerUri
}

func (m *_RegisteredServer) GetDiscoveryUrls() []PascalString {
	return m.DiscoveryUrls
}

func (m *_RegisteredServer) GetSemaphoreFilePath() PascalString {
	return m.SemaphoreFilePath
}

func (m *_RegisteredServer) GetIsOnline() bool {
	return m.IsOnline
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastRegisteredServer(structType any) RegisteredServer {
	if casted, ok := structType.(RegisteredServer); ok {
		return casted
	}
	if casted, ok := structType.(*RegisteredServer); ok {
		return *casted
	}
	return nil
}

func (m *_RegisteredServer) GetTypeName() string {
	return "RegisteredServer"
}

func (m *_RegisteredServer) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (serverUri)
	lengthInBits += m.ServerUri.GetLengthInBits(ctx)

	// Simple field (productUri)
	lengthInBits += m.ProductUri.GetLengthInBits(ctx)

	// Implicit Field (noOfServerNames)
	lengthInBits += 32

	// Array field
	if len(m.ServerNames) > 0 {
		for _curItem, element := range m.ServerNames {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ServerNames), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (serverType)
	lengthInBits += 32

	// Simple field (gatewayServerUri)
	lengthInBits += m.GatewayServerUri.GetLengthInBits(ctx)

	// Implicit Field (noOfDiscoveryUrls)
	lengthInBits += 32

	// Array field
	if len(m.DiscoveryUrls) > 0 {
		for _curItem, element := range m.DiscoveryUrls {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DiscoveryUrls), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (semaphoreFilePath)
	lengthInBits += m.SemaphoreFilePath.GetLengthInBits(ctx)

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (isOnline)
	lengthInBits += 1

	return lengthInBits
}

func (m *_RegisteredServer) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_RegisteredServer) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__registeredServer RegisteredServer, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("RegisteredServer"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for RegisteredServer")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	serverUri, err := ReadSimpleField[PascalString](ctx, "serverUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverUri' field"))
	}
	m.ServerUri = serverUri

	productUri, err := ReadSimpleField[PascalString](ctx, "productUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'productUri' field"))
	}
	m.ProductUri = productUri

	noOfServerNames, err := ReadImplicitField[int32](ctx, "noOfServerNames", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfServerNames' field"))
	}
	_ = noOfServerNames

	serverNames, err := ReadCountArrayField[LocalizedText](ctx, "serverNames", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer), uint64(noOfServerNames))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverNames' field"))
	}
	m.ServerNames = serverNames

	serverType, err := ReadEnumField[ApplicationType](ctx, "serverType", "ApplicationType", ReadEnum(ApplicationTypeByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverType' field"))
	}
	m.ServerType = serverType

	gatewayServerUri, err := ReadSimpleField[PascalString](ctx, "gatewayServerUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'gatewayServerUri' field"))
	}
	m.GatewayServerUri = gatewayServerUri

	noOfDiscoveryUrls, err := ReadImplicitField[int32](ctx, "noOfDiscoveryUrls", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfDiscoveryUrls' field"))
	}
	_ = noOfDiscoveryUrls

	discoveryUrls, err := ReadCountArrayField[PascalString](ctx, "discoveryUrls", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfDiscoveryUrls))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'discoveryUrls' field"))
	}
	m.DiscoveryUrls = discoveryUrls

	semaphoreFilePath, err := ReadSimpleField[PascalString](ctx, "semaphoreFilePath", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'semaphoreFilePath' field"))
	}
	m.SemaphoreFilePath = semaphoreFilePath

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	isOnline, err := ReadSimpleField(ctx, "isOnline", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isOnline' field"))
	}
	m.IsOnline = isOnline

	if closeErr := readBuffer.CloseContext("RegisteredServer"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for RegisteredServer")
	}

	return m, nil
}

func (m *_RegisteredServer) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_RegisteredServer) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("RegisteredServer"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for RegisteredServer")
		}

		if err := WriteSimpleField[PascalString](ctx, "serverUri", m.GetServerUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'serverUri' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "productUri", m.GetProductUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'productUri' field")
		}
		noOfServerNames := int32(utils.InlineIf(bool((m.GetServerNames()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetServerNames()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfServerNames", noOfServerNames, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfServerNames' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "serverNames", m.GetServerNames(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'serverNames' field")
		}

		if err := WriteSimpleEnumField[ApplicationType](ctx, "serverType", "ApplicationType", m.GetServerType(), WriteEnum[ApplicationType, uint32](ApplicationType.GetValue, ApplicationType.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'serverType' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "gatewayServerUri", m.GetGatewayServerUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'gatewayServerUri' field")
		}
		noOfDiscoveryUrls := int32(utils.InlineIf(bool((m.GetDiscoveryUrls()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetDiscoveryUrls()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfDiscoveryUrls", noOfDiscoveryUrls, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfDiscoveryUrls' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "discoveryUrls", m.GetDiscoveryUrls(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'discoveryUrls' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "semaphoreFilePath", m.GetSemaphoreFilePath(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'semaphoreFilePath' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "isOnline", m.GetIsOnline(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'isOnline' field")
		}

		if popErr := writeBuffer.PopContext("RegisteredServer"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for RegisteredServer")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_RegisteredServer) IsRegisteredServer() {}

func (m *_RegisteredServer) DeepCopy() any {
	return m.deepCopy()
}

func (m *_RegisteredServer) deepCopy() *_RegisteredServer {
	if m == nil {
		return nil
	}
	_RegisteredServerCopy := &_RegisteredServer{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.ServerUri),
		utils.DeepCopy[PascalString](m.ProductUri),
		utils.DeepCopySlice[LocalizedText, LocalizedText](m.ServerNames),
		m.ServerType,
		utils.DeepCopy[PascalString](m.GatewayServerUri),
		utils.DeepCopySlice[PascalString, PascalString](m.DiscoveryUrls),
		utils.DeepCopy[PascalString](m.SemaphoreFilePath),
		m.IsOnline,
		m.reservedField0,
	}
	_RegisteredServerCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _RegisteredServerCopy
}

func (m *_RegisteredServer) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
