/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class XVType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12080");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12082");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12090");
    private final Double x;
    private final Float value;

    public XVType(Double x, Float value) {
        this.x = x;
        this.value = value;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public Double getX() {
        return this.x;
    }

    public Float getValue() {
        return this.value;
    }

    protected XVType(XVTypeBuilder<?, ?> b) {
        super(b);
        this.x = ((XVTypeBuilder)b).x;
        this.value = ((XVTypeBuilder)b).value;
    }

    public static XVTypeBuilder<?, ?> builder() {
        return new XVTypeBuilderImpl();
    }

    public XVTypeBuilder<?, ?> toBuilder() {
        return new XVTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XVType)) {
            return false;
        }
        XVType other = (XVType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$x = this.getX();
        Double other$x = other.getX();
        if (this$x == null ? other$x != null : !((Object)this$x).equals(other$x)) {
            return false;
        }
        Float this$value = this.getValue();
        Float other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XVType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $x = this.getX();
        result = result * 59 + ($x == null ? 43 : ((Object)$x).hashCode());
        Float $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "XVType(x=" + this.getX() + ", value=" + this.getValue() + ")";
    }

    private static final class XVTypeBuilderImpl
    extends XVTypeBuilder<XVType, XVTypeBuilderImpl> {
        private XVTypeBuilderImpl() {
        }

        @Override
        protected XVTypeBuilderImpl self() {
            return this;
        }

        @Override
        public XVType build() {
            return new XVType(this);
        }
    }

    public static abstract class XVTypeBuilder<C extends XVType, B extends XVTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private Double x;
        private Float value;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            XVTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(XVType instance, XVTypeBuilder<?, ?> b) {
            b.x(instance.x);
            b.value(instance.value);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B x(Double x) {
            this.x = x;
            return (B)this.self();
        }

        public B value(Float value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "XVType.XVTypeBuilder(super=" + super.toString() + ", x=" + this.x + ", value=" + this.value + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<XVType> {
        @Override
        public Class<XVType> getType() {
            return XVType.class;
        }

        @Override
        public XVType decode(SerializationContext context, UaDecoder decoder) {
            Double x = decoder.readDouble("X");
            Float value = decoder.readFloat("Value");
            return new XVType(x, value);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, XVType value) {
            encoder.writeDouble("X", value.getX());
            encoder.writeFloat("Value", value.getValue());
        }
    }
}

