/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types;

import java.util.Map;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.jetbrains.annotations.Nullable;

public interface DataTypeDictionary<T extends DataTypeCodec> {
    public String getNamespaceUri();

    public QualifiedName getEncodingName();

    public void registerEnumCodec(T var1, String var2);

    public void registerEnumCodec(T var1, String var2, NodeId var3);

    public void registerStructCodec(T var1, String var2, NodeId var3, NodeId var4);

    public T getCodec(String var1);

    public T getCodec(NodeId var1);

    public Map<String, T> getCodecsByDescription();

    public Map<NodeId, T> getCodecsByEncodingId();

    public Map<NodeId, T> getCodecsByDataTypeId();

    @Nullable
    default public T getCodecByDescription(String description) {
        return (T)((DataTypeCodec)this.getCodecsByDescription().get(description));
    }

    @Nullable
    default public T getCodecByEncodingId(NodeId nodeId) {
        return (T)((DataTypeCodec)this.getCodecsByEncodingId().get(nodeId));
    }

    @Nullable
    default public T getCodecByDataTypeId(NodeId dataTypeId) {
        return (T)((DataTypeCodec)this.getCodecsByDataTypeId().get(dataTypeId));
    }
}

