/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.Checkpoint;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointReader {
    private static final Logger logger = LoggerFactory.getLogger(CheckpointReader.class);
    private final File logFile;
    private long maxMemTableId;
    private List<Checkpoint> checkpoints;

    public CheckpointReader(File logFile) {
        this.logFile = logFile;
        this.init();
    }

    private void init() {
        this.checkpoints = new ArrayList<Checkpoint>();
        try (DataInputStream logStream = new DataInputStream(new WALInputStream(this.logFile));){
            this.maxMemTableId = logStream.readLong();
            while (logStream.available() > 0) {
                Checkpoint checkpoint = Checkpoint.deserialize(logStream);
                this.checkpoints.add(checkpoint);
            }
        }
        catch (IOException e) {
            logger.warn("Meet error when reading checkpoint file {}, skip broken checkpoints", (Object)this.logFile, (Object)e);
        }
    }

    public long getMaxMemTableId() {
        return this.maxMemTableId;
    }

    public List<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }
}

