/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class InputLocation {
    private final int tsBlockIndex;
    private final int valueColumnIndex;

    public InputLocation(int tsBlockIndex, int valueColumnIndex) {
        this.tsBlockIndex = tsBlockIndex;
        this.valueColumnIndex = valueColumnIndex;
    }

    public int getTsBlockIndex() {
        return this.tsBlockIndex;
    }

    public int getValueColumnIndex() {
        return this.valueColumnIndex;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.tsBlockIndex, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.valueColumnIndex, (ByteBuffer)byteBuffer);
    }

    public static InputLocation deserialize(ByteBuffer byteBuffer) {
        int tsBlockIndex = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        int valueColumnIndex = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        return new InputLocation(tsBlockIndex, valueColumnIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputLocation that = (InputLocation)o;
        return this.tsBlockIndex == that.tsBlockIndex && this.valueColumnIndex == that.valueColumnIndex;
    }

    public int hashCode() {
        return Objects.hash(this.tsBlockIndex, this.valueColumnIndex);
    }
}

