/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.proxy.impl;

import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class BridgeServiceTracker<T>
extends ServiceTracker<T, T> {
    private static final String DEFAULT_FILTER = "(http.felix.dispatcher=*)";
    private volatile T usedService;

    public BridgeServiceTracker(BundleContext context, Class<?> objectClass) throws InvalidSyntaxException {
        super(context, BridgeServiceTracker.createFilter(context, objectClass), null);
    }

    protected abstract void setService(T var1);

    protected abstract void unsetService();

    public T addingService(ServiceReference<T> ref) {
        Object service = super.addingService(ref);
        if (this.usedService == null) {
            this.usedService = service;
            this.setService(service);
        }
        return (T)service;
    }

    public void removedService(ServiceReference<T> ref, T service) {
        if (service == this.usedService) {
            this.unsetService();
        }
        super.removedService(ref, service);
    }

    private static Filter createFilter(BundleContext context, Class<?> objectClass) throws InvalidSyntaxException {
        StringBuffer str = new StringBuffer();
        str.append("(&(").append("objectClass").append("=");
        str.append(objectClass.getName()).append(")");
        str.append(DEFAULT_FILTER).append(")");
        return context.createFilter(str.toString());
    }
}

