/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaListener;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SequenceManager;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.workers.SenderWorker;
import org.apache.sandesha2.workers.WorkerLock;
import org.apache.sandesha2.wsrm.CreateSequence;
import org.apache.sandesha2.wsrm.SequenceOffer;

public class ApplicationMsgProcessor
implements MsgProcessor {
    private static final Log log = LogFactory.getLog(ApplicationMsgProcessor.class);
    private String inboundSequence = null;
    private long inboundMessageNumber;
    private Transaction appMsgProcTran = null;

    public ApplicationMsgProcessor() {
    }

    public ApplicationMsgProcessor(String inboundSequenceId, long inboundMessageNumber) {
        this.inboundSequence = inboundSequenceId;
        this.inboundMessageNumber = inboundMessageNumber;
    }

    public boolean processInMessage(RMMsgContext rmMsgCtx, Transaction transaction) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: ApplicationMsgProcessor::processInMessage");
            log.debug((Object)"Exit: ApplicationMsgProcessor::processInMessage");
        }
        return false;
    }

    private String getSequenceID(RMMsgContext rmMsgCtx, boolean serverSide, boolean forceNewSequence) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: ApplicationMsgProcessor::getSequenceID " + rmMsgCtx + ", " + serverSide + ", " + forceNewSequence));
        }
        MessageContext msgContext = rmMsgCtx.getMessageContext();
        ConfigurationContext configContext = msgContext.getConfigurationContext();
        String internalSequenceId = null;
        if (serverSide) {
            if (this.inboundSequence == null || "".equals(this.inboundSequence)) {
                String message = SandeshaMessageHelper.getMessage("incomingSequenceNotValidID", this.inboundSequence);
                log.debug((Object)message);
                throw new SandeshaException(message);
            }
            internalSequenceId = SandeshaUtil.getOutgoingSideInternalSequenceID(this.inboundSequence);
        } else {
            EndpointReference toEPR = msgContext.getTo();
            if (toEPR == null || toEPR.getAddress() == null || "".equals(toEPR.getAddress())) {
                String message = SandeshaMessageHelper.getMessage("toEPRNotValid", null);
                log.debug((Object)message);
                throw new SandeshaException(message);
            }
            String to = toEPR.getAddress();
            String sequenceKey = null;
            if (forceNewSequence) {
                try {
                    sequenceKey = SandeshaUtil.getUUID();
                    msgContext.setProperty("Sandesha2SequenceKey", (Object)sequenceKey);
                    configContext.getAxisConfiguration().addParameter(new Parameter("Sandesha2SequenceKey", (Object)sequenceKey));
                }
                catch (AxisFault e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Enter: ApplicationMsgProcessor::getSequenceID " + (Object)((Object)e)));
                    }
                    throw new SandeshaException((Exception)((Object)e));
                }
            } else {
                sequenceKey = (String)msgContext.getProperty("Sandesha2SequenceKey");
                if (sequenceKey == null) {
                    sequenceKey = (String)configContext.getAxisConfiguration().getParameterValue("Sandesha2SequenceKey");
                }
            }
            internalSequenceId = SandeshaUtil.getInternalSequenceID(to, sequenceKey);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: ApplicationMsgProcessor::getSequenceID " + internalSequenceId));
        }
        return internalSequenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processOutMessage(RMMsgContext rmMsgCtx, Transaction tran) throws AxisFault {
        String lastAppMessage;
        OperationContext operationContext;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: ApplicationMsgProcessor::processOutMessage");
        }
        this.appMsgProcTran = tran;
        MessageContext msgContext = rmMsgCtx.getMessageContext();
        ConfigurationContext configContext = msgContext.getConfigurationContext();
        SandeshaListener faultCallback = (SandeshaListener)msgContext.getOptions().getProperty("Sandesha2Listener");
        if (faultCallback != null && (operationContext = msgContext.getOperationContext()) != null) {
            operationContext.setProperty("Sandesha2Listener", (Object)faultCallback);
        }
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configContext, (AxisDescription)configContext.getAxisConfiguration());
        SandeshaUtil.getEPRDecorator(configContext).checkEndpointReference(msgContext.getTo());
        boolean serverSide = msgContext.isServerSide();
        if (msgContext.getMessageID() == null) {
            msgContext.setMessageID(SandeshaUtil.getUUID());
        }
        String internalSequenceId = this.getSequenceID(rmMsgCtx, serverSide, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: ApplicationMsgProcessor::internalSequenceId = " + internalSequenceId));
        }
        boolean lastMessage = false;
        if (!serverSide && (lastAppMessage = (String)msgContext.getProperty("Sandesha2LastMessage")) != null && "true".equals(lastAppMessage)) {
            lastMessage = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Enter: ApplicationMsgProcessor: last message");
            }
        }
        if (internalSequenceId != null) {
            rmMsgCtx.setProperty("Sandesha2InternalSequenceId", internalSequenceId);
        }
        Long messageNumberLng = (Long)msgContext.getProperty("Sandesha2MessageNumber");
        long givenMessageNumber = -1L;
        if (messageNumberLng != null && (givenMessageNumber = messageNumberLng.longValue()) <= 0L) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("msgNumberMustBeLargerThanZero", Long.toString(givenMessageNumber)));
        }
        String dummyMessageString = (String)msgContext.getOptions().getProperty("Sandesha2DummyMessage");
        boolean dummyMessage = false;
        if (dummyMessageString != null && "true".equals(dummyMessageString)) {
            dummyMessage = true;
        }
        RMSBean rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
        boolean autoStartNewSeqForReallocation = false;
        if (rmsBean != null) {
            int seqReallocated = rmsBean.isReallocated();
            if (seqReallocated == 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ApplicationMsgProcessor: Reallocated Sequence: " + rmsBean.getSequenceID()));
                }
                if ((internalSequenceId = rmsBean.getInternalSeqIDOfSeqUsedForReallocation()) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("ApplicationMsgProcessor: InternalSeqID of new sequence: " + internalSequenceId));
                    }
                    rmMsgCtx.setProperty("Sandesha2InternalSequenceId", internalSequenceId);
                    rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
                } else {
                    autoStartNewSeqForReallocation = true;
                }
            } else if (seqReallocated == -1) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("reallocationFailed", rmsBean.getSequenceID(), "We have already attempted to reallocate this Sequence and we won't try again.  The sequance needs to be cleaned up manually."));
            }
            if (rmsBean.isSequenceClosedClient() || rmsBean.isTerminateAdded() || rmsBean.isTimedOut() || autoStartNewSeqForReallocation) {
                if (SandeshaUtil.isAutoStartNewSequence(msgContext)) {
                    internalSequenceId = this.getSequenceID(rmMsgCtx, serverSide, true);
                    if (autoStartNewSeqForReallocation) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("ApplicationMsgProcessor: autoStartNewSeqForReallocation: InternalSeqID of new sequence used for reallocation: " + internalSequenceId));
                        }
                        rmsBean.setInternalSeqIDOfSeqUsedForReallocation(internalSequenceId);
                        storageManager.getRMSBeanMgr().update(rmsBean);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("ApplicationMsgProcessor: auto start new sequence " + internalSequenceId + " :: " + rmsBean));
                    }
                    rmMsgCtx.setProperty("Sandesha2InternalSequenceId", internalSequenceId);
                    rmsBean = null;
                } else {
                    if (rmsBean.isSequenceClosedClient()) {
                        throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotSendMsgAsSequenceClosed", internalSequenceId));
                    }
                    if (rmsBean.isTerminateAdded()) {
                        throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotSendMsgAsSequenceTerminated", internalSequenceId));
                    }
                    if (rmsBean.isTimedOut()) {
                        throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotSendMsgAsSequenceTimedout", internalSequenceId));
                    }
                }
            } else if (!msgContext.isServerSide()) {
                boolean isSequenceAnon;
                boolean msgIsAnon = !AddressingHelper.isReplyRedirected((MessageContext)msgContext);
                boolean bl = isSequenceAnon = rmsBean.getReplyToEndpointReference() == null || rmsBean.getReplyToEndpointReference().getAddress() == null || rmsBean.getReplyToEndpointReference().hasAnonymousAddress();
                if (msgIsAnon != isSequenceAnon && SandeshaUtil.isForbidMixedEPRsOnSequence(msgContext)) {
                    String msg = SandeshaMessageHelper.getMessage("cannotSendMsgAsEPRWrong", msgContext.toString(), rmsBean.getSequenceID());
                    log.warn((Object)msg);
                    throw new SandeshaException(msg);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: ApplicationMsgProcessor:: initial sequence checks pass");
        }
        if (!serverSide) {
            AxisOperation op = msgContext.getAxisOperation();
            int mep = -1;
            if (op != null) {
                mep = op.getAxisSpecificMEPConstant();
            }
            if (mep == 16) {
                String specVersion = null;
                specVersion = rmsBean == null ? SequenceManager.getSpecVersion(msgContext, storageManager) : rmsBean.getRMVersion();
            }
        }
        if (rmsBean != null && rmsBean.getReferenceMessageStoreKey() == null) {
            String referenceMsgKey = SandeshaUtil.getUUID();
            storageManager.storeMessageContext(referenceMsgKey, msgContext);
            rmsBean.setReferenceMessageStoreKey(referenceMsgKey);
        }
        String outSequenceID = null;
        boolean hasUserTransaction = storageManager.hasUserTransaction(msgContext);
        try {
            EndpointReference toEPR;
            SOAPBody soapBody;
            EndpointReference reference;
            SandeshaPolicyBean policy;
            RelatesTo relatesTo;
            if (rmsBean == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Enter: ApplicationMsgProcessor:: sending createSequence");
                }
                while (rmsBean == null) {
                    rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
                    if (rmsBean != null) continue;
                    rmsBean = SequenceManager.setupNewClientSequence(msgContext, internalSequenceId, storageManager);
                    rmsBean = this.addCreateSequenceMessage(rmMsgCtx, rmsBean, storageManager);
                    if (autoStartNewSeqForReallocation) {
                        rmsBean.setReallocated(3);
                    }
                    if (rmsBean != null) {
                        outSequenceID = rmsBean.getSequenceID();
                    }
                    if (rmsBean != null || this.appMsgProcTran == null || !this.appMsgProcTran.isActive()) continue;
                    this.appMsgProcTran.rollback();
                    this.appMsgProcTran = storageManager.getTransaction();
                }
            } else {
                outSequenceID = rmsBean.getSequenceID();
            }
            long systemMessageNumber = rmsBean.getNextMessageNumber();
            if (givenMessageNumber > 0L && givenMessageNumber <= systemMessageNumber) {
                String message = SandeshaMessageHelper.getMessage("msgNumberNotLargerThanLastMsg", Long.toString(givenMessageNumber));
                throw new SandeshaException(message);
            }
            long messageNumber = -1L;
            messageNumber = givenMessageNumber > 0L ? givenMessageNumber : (systemMessageNumber > 0L ? systemMessageNumber + 1L : 1L);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enter: ApplicationMsgProcessor::message number=" + messageNumber));
            }
            if (serverSide) {
                Boolean inboundLast;
                RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, this.inboundSequence);
                String lastRequestId = rmdBean.getLastInMessageId();
                relatesTo = msgContext.getRelatesTo();
                if (relatesTo != null && lastRequestId != null && lastRequestId.equals(relatesTo.getValue())) {
                    lastMessage = true;
                }
                if ((inboundLast = (Boolean)msgContext.getProperty("Sandesha2InboundLastMessage")) != null && inboundLast.booleanValue()) {
                    lastMessage = true;
                }
            }
            if (lastMessage) {
                rmsBean.setLastOutMessage(messageNumber);
                if (msgContext.getTo() == null || msgContext.getTo() != null && msgContext.getTo().isWSAddressingAnonymous()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Rewriting anonymous EPR for LastMessage to the one stored in the RMSBean");
                    }
                    msgContext.setTo(rmsBean.getToEndpointReference());
                }
            }
            rmsBean.setHighestOutMessageNumber(messageNumber);
            String specVersion = SequenceManager.getSpecVersion(rmMsgCtx.getMessageContext(), storageManager);
            if (!dummyMessage) {
                rmsBean.setNextMessageNumber(messageNumber);
                AxisOperation op = msgContext.getAxisOperation();
                int mep = -1;
                if (op != null) {
                    mep = op.getAxisSpecificMEPConstant();
                }
                EndpointReference replyTo = msgContext.getReplyTo();
                if (mep == 16) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"MEP OUT_IN");
                    }
                    if (replyTo == null || replyTo.hasAnonymousAddress()) {
                        long expectedReplies = rmsBean.getExpectedReplies();
                        rmsBean.setExpectedReplies(expectedReplies + 1L);
                    }
                    if ("Spec_2007_02".equals(specVersion)) {
                        String newAddress;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"SPEC_1_1");
                        }
                        String oldAddress = replyTo == null ? null : replyTo.getAddress();
                        EndpointReference newReplyTo = SandeshaUtil.rewriteEPR(rmsBean, msgContext.getReplyTo(), configContext);
                        String string = newAddress = newReplyTo == null ? null : newReplyTo.getAddress();
                        if (newAddress != null && !newAddress.equals(oldAddress)) {
                            msgContext.setReplyTo(newReplyTo);
                        }
                    }
                }
                if (mep == 14 || "Spec_2005_02".equals(specVersion) && replyTo == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Setting the faultTo to anonymous as a oneWay MEP is being used and fault msgs can then be delivered back on the backchannel");
                    }
                    if (msgContext.getFaultTo() == null) {
                        msgContext.setFaultTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
                    }
                }
            }
            boolean startPolling = false;
            if ("Spec_2007_02".equals(specVersion) && (policy = SandeshaUtil.getPropertyBean((AxisDescription)msgContext.getConfigurationContext().getAxisConfiguration())).isEnableMakeConnection() && ((reference = rmsBean.getAcksToEndpointReference()) == null || reference.hasAnonymousAddress())) {
                rmsBean.setPollingMode(true);
                startPolling = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Ensuring that WS-A is enabled for msg " + msgContext));
                }
                msgContext.setProperty("disableAddressingForOutMessages", (Object)Boolean.FALSE);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("App msg using replyTo EPR as " + msgContext.getReplyTo() + " and faultTo EPR as " + msgContext.getFaultTo()));
            }
            if ((relatesTo = msgContext.getRelatesTo()) != null) {
                rmsBean.setHighestOutRelatesTo(relatesTo.getValue());
            }
            if (serverSide && rmsBean.getToEndpointReference() != null) {
                msgContext.setProperty("Sandesha2AcksTo", (Object)rmsBean.getToEndpointReference().getAddress());
            }
            storageManager.getRMSBeanMgr().update(rmsBean);
            if (startPolling) {
                SandeshaUtil.startWorkersForSequence(msgContext.getConfigurationContext(), rmsBean);
            }
            int SOAPVersion2 = 1;
            if (!msgContext.isSOAP11()) {
                SOAPVersion2 = 2;
            }
            if (msgContext.getEnvelope() == null) {
                try {
                    msgContext.setEnvelope(SOAPAbstractFactory.getSOAPFactory(SOAPVersion2).getDefaultEnvelope());
                }
                catch (AxisFault e) {
                    throw new SandeshaException(e.getMessage());
                }
            }
            if ((soapBody = rmMsgCtx.getSOAPEnvelope().getBody()) == null) {
                String message = SandeshaMessageHelper.getMessage("soapBodyNotPresent");
                log.debug((Object)message);
                throw new SandeshaException(message);
            }
            if (rmMsgCtx.getMessageId() == null) {
                String messageId1 = SandeshaUtil.getUUID();
                rmMsgCtx.setMessageId(messageId1);
            }
            if ((toEPR = msgContext.getTo()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Enter: ApplicationMsgProcessor::setting default actions");
                }
                String to = toEPR.getAddress();
                String operationName = msgContext.getOperationContext().getAxisOperation().getName().getLocalPart();
                if (msgContext.getWSAAction() == null) {
                    msgContext.setWSAAction(to + "/" + operationName);
                }
                if (msgContext.getSoapAction() == null) {
                    msgContext.setSoapAction("\"" + to + "/" + operationName + "\"");
                }
            }
            if (!dummyMessage) {
                String storageKey = SandeshaUtil.getUUID();
                this.processResponseMessage(rmMsgCtx, rmsBean, internalSequenceId, outSequenceID, messageNumber, storageKey, storageManager, tran, hasUserTransaction);
            }
            msgContext.pause();
            if (this.appMsgProcTran != null && this.appMsgProcTran.isActive()) {
                this.appMsgProcTran.commit();
                this.appMsgProcTran = null;
            }
        }
        finally {
            if (this.appMsgProcTran != null && this.appMsgProcTran.isActive()) {
                this.appMsgProcTran.rollback();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: ApplicationMsgProcessor::processOutMessage " + Boolean.TRUE));
        }
        return true;
    }

    private RMSBean addCreateSequenceMessage(RMMsgContext applicationRMMsg, RMSBean rmsBean, StorageManager storageManager) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: ApplicationMsgProcessor::addCreateSequenceMessage, " + rmsBean));
        }
        MessageContext applicationMsg = applicationRMMsg.getMessageContext();
        ConfigurationContext configCtx = applicationMsg.getConfigurationContext();
        RMMsgContext createSeqRMMessage = RMMsgCreator.createCreateSeqMsg(rmsBean, applicationRMMsg);
        createSeqRMMessage.setFlow(2);
        CreateSequence createSequencePart = createSeqRMMessage.getCreateSequence();
        SequenceOffer offer = createSequencePart.getSequenceOffer();
        if (offer != null) {
            String offeredSequenceId = offer.getIdentifer().getIdentifier();
            rmsBean.setOfferedSequence(offeredSequenceId);
        }
        MessageContext createSeqMsg = createSeqRMMessage.getMessageContext();
        createSeqMsg.setRelationships(null);
        String createSequenceMessageStoreKey = SandeshaUtil.getUUID();
        rmsBean.setCreateSeqMsgID(createSeqMsg.getMessageID());
        rmsBean.setCreateSequenceMsgStoreKey(createSequenceMessageStoreKey);
        if (storageManager.getRMSBeanMgr().insert(rmsBean)) {
            MessageContext clonedMessage = SandeshaUtil.cloneMessageContext(createSeqMsg);
            String clonedMsgStoreKey = SandeshaUtil.getUUID();
            storageManager.storeMessageContext(clonedMsgStoreKey, clonedMessage);
            rmsBean.setReferenceMessageStoreKey(clonedMsgStoreKey);
            SecurityToken token = (SecurityToken)createSeqRMMessage.getProperty("SecurityToken");
            if (token != null) {
                SecurityManager secManager = SandeshaUtil.getSecurityManager(configCtx);
                rmsBean.setSecurityTokenData(secManager.getTokenRecoveryData(token));
            }
            storageManager.getRMSBeanMgr().update(rmsBean);
            SenderBean createSeqEntry = new SenderBean();
            createSeqEntry.setMessageContextRefKey(createSequenceMessageStoreKey);
            createSeqEntry.setTimeToSend(System.currentTimeMillis());
            createSeqEntry.setMessageID(createSeqRMMessage.getMessageId());
            createSeqEntry.setInternalSequenceID(rmsBean.getInternalSequenceID());
            createSeqEntry.setSend(true);
            createSeqEntry.setMessageType(1);
            EndpointReference to = createSeqRMMessage.getTo();
            if (to != null) {
                createSeqEntry.setToAddress(to.getAddress());
            }
            if (to == null || to.hasAnonymousAddress()) {
                createSeqEntry.setTransportAvailable(false);
            }
            createSeqMsg.setProperty("Sandesha2QualifiedForSending", (Object)"false");
            SandeshaUtil.executeAndStore(createSeqRMMessage, createSequenceMessageStoreKey, storageManager);
            storageManager.getSenderBeanMgr().insert(createSeqEntry);
            if (this.appMsgProcTran != null && createSeqRMMessage.getMessageId() != null && !storageManager.hasUserTransaction(createSeqMsg)) {
                String workId = createSeqEntry.getMessageID() + createSeqEntry.getTimeToSend();
                SandeshaThread sender = storageManager.getSender();
                ConfigurationContext context = createSeqMsg.getConfigurationContext();
                WorkerLock lock = sender.getWorkerLock();
                SenderWorker worker = new SenderWorker(context, createSeqEntry, rmsBean.getRMVersion());
                worker.setLock(lock);
                worker.setWorkId(workId);
                lock.addWork(workId, worker);
                if (this.appMsgProcTran.isActive()) {
                    this.appMsgProcTran.commit();
                }
                if (worker != null) {
                    try {
                        worker.run();
                    }
                    catch (Exception e) {
                        log.debug((Object)"Caught exception running SandeshaWorker", (Throwable)e);
                    }
                }
                this.appMsgProcTran = storageManager.getTransaction();
                RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
                RMSBean tempRMSBean = new RMSBean();
                tempRMSBean.setInternalSequenceID(rmsBean.getInternalSequenceID());
                rmsBean = rmsBeanMgr.findUnique(tempRMSBean);
                if (rmsBean == null || rmsBean.isTerminated()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exit: ApplicationMsgProcessor::addCreateSequenceMessage, Failed to establish sequence " + rmsBean));
                    }
                    if (rmsBean != null && rmsBean.getLastSendError() != null) {
                        if (rmsBean.getLastSendError() instanceof AxisFault) {
                            throw (AxisFault)((Object)rmsBean.getLastSendError());
                        }
                        throw new AxisFault(SandeshaMessageHelper.getMessage("createSequenceRefused"), (Throwable)rmsBean.getLastSendError());
                    }
                    throw new AxisFault(SandeshaMessageHelper.getMessage("createSequenceRefused"));
                }
            }
            SandeshaUtil.startWorkersForSequence(configCtx, rmsBean);
        } else {
            rmsBean = null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: ApplicationMsgProcessor::addCreateSequenceMessage, " + rmsBean));
        }
        return rmsBean;
    }

    private void processResponseMessage(RMMsgContext rmMsg, RMSBean rmsBean, String internalSequenceId, String outSequenceID, long messageNumber, String storageKey, StorageManager storageManager, Transaction tran, boolean hasUserTransaction) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: ApplicationMsgProcessor::processResponseMessage, " + internalSequenceId + ", " + outSequenceID));
        }
        MessageContext msg = rmMsg.getMessageContext();
        SenderBeanMgr retransmitterMgr = storageManager.getSenderBeanMgr();
        boolean lastMessage = false;
        if (msg.isServerSide()) {
            Boolean inboundLast = (Boolean)msg.getProperty("Sandesha2InboundLastMessage");
            if (inboundLast != null && inboundLast.booleanValue()) {
                lastMessage = true;
            }
        } else {
            Object obj = msg.getProperty("Sandesha2LastMessage");
            if (obj != null && "true".equals(obj)) {
                lastMessage = true;
            }
        }
        boolean sendingNow = false;
        if (outSequenceID != null && !hasUserTransaction) {
            sendingNow = true;
        }
        RMMsgCreator.secureOutboundMessage(rmsBean, msg);
        SenderBean appMsgEntry = new SenderBean();
        appMsgEntry.setMessageContextRefKey(storageKey);
        appMsgEntry.setTimeToSend(System.currentTimeMillis());
        appMsgEntry.setMessageID(rmMsg.getMessageId());
        appMsgEntry.setMessageNumber(messageNumber);
        appMsgEntry.setLastMessage(lastMessage);
        SOAPEnvelope envelope = rmMsg.getSOAPEnvelope();
        if (lastMessage && envelope != null && envelope.getBody().getFirstOMChild() == null) {
            appMsgEntry.setMessageType(12);
        } else {
            appMsgEntry.setMessageType(3);
        }
        appMsgEntry.setInboundSequenceId(this.inboundSequence);
        appMsgEntry.setInboundMessageNumber(this.inboundMessageNumber);
        if (outSequenceID == null) {
            appMsgEntry.setSend(false);
        } else {
            appMsgEntry.setSend(true);
            msg.setProperty("Sandesha2SetSendToTrue", (Object)"true");
            appMsgEntry.setSequenceID(outSequenceID);
        }
        EndpointReference to = rmMsg.getTo();
        if (to != null) {
            appMsgEntry.setToAddress(to.getAddress());
        }
        appMsgEntry.setInternalSequenceID(internalSequenceId);
        msg.setProperty("Sandesha2QualifiedForSending", (Object)"false");
        msg.setCurrentHandlerIndex(msg.getCurrentHandlerIndex() + 1);
        SandeshaUtil.executeAndStore(rmMsg, storageKey, storageManager);
        retransmitterMgr.insert(appMsgEntry);
        SenderWorker worker = null;
        if (sendingNow) {
            String workId = appMsgEntry.getMessageID() + appMsgEntry.getTimeToSend();
            SandeshaThread sender = storageManager.getSender();
            ConfigurationContext context = msg.getConfigurationContext();
            WorkerLock lock = sender.getWorkerLock();
            worker = new SenderWorker(context, appMsgEntry, rmsBean.getRMVersion());
            worker.setLock(lock);
            worker.setWorkId(workId);
            lock.addWork(workId, worker);
        }
        if (this.appMsgProcTran != null && this.appMsgProcTran.isActive()) {
            this.appMsgProcTran.commit();
        }
        if (worker != null) {
            try {
                worker.run();
            }
            catch (Exception e) {
                log.error((Object)"Caught exception running SandeshaWorker", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: ApplicationMsgProcessor::processResponseMessage");
        }
    }
}

