/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.vfs2.util.CombinedResources;

public final class Messages {
    private static ConcurrentMap<String, MessageFormat> messageMap = new ConcurrentHashMap<String, MessageFormat>();
    private static final ResourceBundle RESOURCES = new CombinedResources("org.apache.commons.vfs2.Resources");

    private Messages() {
    }

    public static String getString(String code) {
        return Messages.getString(code, new Object[0]);
    }

    @Deprecated
    public static String getString(String code, Object param) {
        return Messages.getString(code, new Object[]{param});
    }

    public static String getString(String code, Object ... params) {
        try {
            if (code == null) {
                return null;
            }
            MessageFormat msg = Messages.findMessage(code);
            return msg.format(params);
        }
        catch (MissingResourceException mre) {
            return "Unknown message with code \"" + code + "\".";
        }
    }

    private static MessageFormat findMessage(String code) throws MissingResourceException {
        MessageFormat msg = (MessageFormat)messageMap.get(code);
        if (msg != null) {
            return msg;
        }
        String msgText = RESOURCES.getString(code);
        msg = new MessageFormat(msgText);
        messageMap.putIfAbsent(code, msg);
        return (MessageFormat)messageMap.get(code);
    }
}

