/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class CombinedResources
extends ResourceBundle {
    private final String resourceName;
    private boolean inited;
    private final Properties properties = new Properties();

    public CombinedResources(String resourceName) {
        this.resourceName = resourceName;
    }

    protected void init() {
        if (this.inited) {
            return;
        }
        this.loadResources(this.getResourceName());
        this.loadResources(Locale.getDefault());
        this.loadResources(this.getLocale());
        this.inited = true;
    }

    protected void loadResources(Locale locale) {
        if (locale == null) {
            return;
        }
        String[] parts = new String[]{locale.getLanguage(), locale.getCountry(), locale.getVariant()};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            sb.append(this.getResourceName());
            for (int j = 0; j < i; ++j) {
                sb.append('_').append(parts[j]);
            }
            if (parts[i].length() != 0) {
                sb.append('_').append(parts[i]);
                this.loadResources(sb.toString());
            }
            sb.setLength(0);
        }
    }

    protected void loadResources(String resourceName) {
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        resourceName = resourceName.replace('.', '/') + ".properties";
        try {
            Enumeration<URL> resources = loader.getResources(resourceName);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try {
                    this.properties.load(resource.openConnection().getInputStream());
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public Enumeration<String> getKeys() {
        if (!this.inited) {
            this.init();
        }
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return CombinedResources.this.properties.keys().hasMoreElements();
            }

            @Override
            public String nextElement() {
                return (String)CombinedResources.this.properties.keys().nextElement();
            }
        };
    }

    @Override
    protected Object handleGetObject(String key) {
        if (!this.inited) {
            this.init();
        }
        return this.properties.get(key);
    }
}

