/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.taskdefs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.ant.compress.resources.CommonsCompressCompressorResource;
import org.apache.ant.compress.taskdefs.ArchiveBase;
import org.apache.ant.compress.util.CompressorStreamFactory;
import org.apache.ant.compress.util.StreamHelper;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.util.FileUtils;

public abstract class PackBase
extends Task {
    private static final int BUFFER_SIZE = 8192;
    private CompressorStreamFactory factory;
    private final ResourceWrapper wrapper;
    private Resource src;
    private ArchiveBase srcArchiveTask;
    private PackBase srcPackTask;
    private Resource dest;

    protected PackBase(CompressorStreamFactory factory, ResourceWrapper wrapper) {
        this(wrapper);
        this.setFactory(factory);
    }

    protected PackBase(ResourceWrapper wrapper) {
        this.wrapper = wrapper;
    }

    protected final void setFactory(CompressorStreamFactory factory) {
        this.factory = factory;
    }

    public void setDestfile(File dest) {
        this.setDest((Resource)new FileResource(dest));
    }

    public void setDest(Resource dest) {
        if (this.dest != null) {
            throw new BuildException("Can only have one destination resource.");
        }
        this.dest = dest;
    }

    public void addConfiguredDest(Resources r) {
        Iterator it = r.iterator();
        while (it.hasNext()) {
            this.setDest((Resource)it.next());
        }
    }

    public void setSrcfile(File src) {
        this.setSrc((Resource)new FileResource(src));
    }

    public void setSrc(Resource src) {
        if (this.src != null || this.srcArchiveTask != null || this.srcPackTask != null) {
            throw new BuildException("Can only have one source.");
        }
        if (src.isDirectory()) {
            throw new BuildException("the source can't be a directory");
        }
        this.src = src;
    }

    public void addConfigured(ResourceCollection a) {
        Iterator it = a.iterator();
        while (it.hasNext()) {
            this.setSrc((Resource)it.next());
        }
    }

    public void add(ArchiveBase task) {
        if (this.src != null || this.srcArchiveTask != null || this.srcPackTask != null) {
            throw new BuildException("Can only have one source.");
        }
        this.srcArchiveTask = task;
    }

    public void add(PackBase task) {
        if (this.src != null || this.srcArchiveTask != null || this.srcPackTask != null) {
            throw new BuildException("Can only have one source.");
        }
        this.srcPackTask = task;
    }

    private void validate() throws BuildException {
        if (this.src == null && this.srcArchiveTask == null && this.srcPackTask == null) {
            throw new BuildException("source is required.", this.getLocation());
        }
        if (this.src != null) {
            if (this.src.isDirectory()) {
                throw new BuildException("source resource must not represent a directory!", this.getLocation());
            }
            if (!this.src.isExists()) {
                throw new BuildException("source resource must exist.");
            }
        }
        if (this.dest == null) {
            throw new BuildException("dest resource is required.", this.getLocation());
        }
        if (this.dest.isDirectory()) {
            throw new BuildException("dest resource must not represent a directory!", this.getLocation());
        }
    }

    public void execute() throws BuildException {
        this.validate();
        if (this.srcArchiveTask != null) {
            this.srcArchiveTask.setDest((Resource)this.wrapper.wrap(this.dest));
            this.srcArchiveTask.setTaskName(this.getTaskName());
            this.srcArchiveTask.execute();
        } else if (this.srcPackTask != null) {
            this.srcPackTask.setDest((Resource)this.wrapper.wrap(this.dest));
            this.srcPackTask.setTaskName(this.getTaskName());
            this.srcPackTask.execute();
        } else if (this.dest.isExists() && this.dest.getLastModified() > this.src.getLastModified()) {
            this.log("Nothing to do: " + this.dest.getName() + " is up to date.");
        } else {
            this.log("Building: " + this.dest.getName());
            this.pack();
        }
    }

    private void pack() {
        InputStream in = null;
        CompressorOutputStream out = null;
        try {
            in = this.src.getInputStream();
            out = StreamHelper.getOutputStream(this.factory, this.dest);
            if (out == null) {
                out = this.factory.getCompressorStream(new BufferedOutputStream(this.dest.getOutputStream()));
            }
            IOUtils.copy((InputStream)in, (OutputStream)out, (int)8192);
        }
        catch (IOException e) {
            try {
                throw new BuildException("Error compressing " + this.src.getName() + " to " + this.dest.getName(), (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.close((InputStream)in);
                FileUtils.close(out);
                throw throwable;
            }
        }
        FileUtils.close((InputStream)in);
        FileUtils.close((OutputStream)out);
    }

    protected final Resource getSrc() {
        return this.src;
    }

    public static interface ResourceWrapper {
        public CommonsCompressCompressorResource wrap(Resource var1);
    }
}

