/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ant.compress.resources.CommonsCompressCompressorResource;
import org.apache.ant.compress.util.DeflateStreamFactory;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateParameters;
import org.apache.tools.ant.types.ResourceCollection;

public final class DeflateResource
extends CommonsCompressCompressorResource {
    private boolean zlibHeader = true;
    private static final String NAME = "DEFLATE";

    public DeflateResource() {
        super(NAME);
        this.setFactory();
    }

    public DeflateResource(ResourceCollection other) {
        super(NAME, other);
        this.setFactory();
    }

    public void setZlibHeader(boolean zlib) {
        this.zlibHeader = zlib;
    }

    private void setFactory() {
        this.setFactory(new DeflateStreamFactory(){

            @Override
            public CompressorOutputStream getCompressorStream(OutputStream stream) throws IOException {
                DeflateParameters params = new DeflateParameters();
                params.setWithZlibHeader(DeflateResource.this.zlibHeader);
                return new DeflateCompressorOutputStream(stream, params);
            }

            @Override
            public CompressorInputStream getCompressorStream(InputStream stream) throws IOException {
                DeflateParameters params = new DeflateParameters();
                params.setWithZlibHeader(DeflateResource.this.zlibHeader);
                return new DeflateCompressorInputStream(stream, params);
            }
        });
    }
}

