/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ant.compress.util.CompressorStreamFactory;
import org.apache.ant.compress.util.CompressorWithConcatenatedStreamsFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.ContentTransformingResource;

public abstract class CommonsCompressCompressorResource
extends ContentTransformingResource {
    private final String name;
    private CompressorStreamFactory factory;
    private boolean decompressConcatenated = false;

    protected CommonsCompressCompressorResource(String name) {
        this.name = name;
    }

    protected CommonsCompressCompressorResource(String name, CompressorStreamFactory factory) {
        this(name);
        this.setFactory(factory);
    }

    protected CommonsCompressCompressorResource(String name, ResourceCollection other) {
        super(other);
        this.name = name;
    }

    protected CommonsCompressCompressorResource(String name, CompressorStreamFactory factory, ResourceCollection other) {
        this(name, other);
        this.setFactory(factory);
    }

    protected final void setFactory(CompressorStreamFactory factory) {
        this.factory = factory;
    }

    public void setDecompressConcatenated(boolean b) {
        if (b && !(this.factory instanceof CompressorWithConcatenatedStreamsFactory)) {
            throw new BuildException("concatenated streams are not supportedby this compression format.");
        }
        this.decompressConcatenated = b;
    }

    protected final InputStream wrapStream(InputStream in) throws IOException {
        if (this.factory instanceof CompressorWithConcatenatedStreamsFactory) {
            CompressorWithConcatenatedStreamsFactory f = (CompressorWithConcatenatedStreamsFactory)this.factory;
            return f.getCompressorStream(new BufferedInputStream(in), this.decompressConcatenated);
        }
        return this.factory.getCompressorStream(new BufferedInputStream(in));
    }

    protected final OutputStream wrapStream(OutputStream out) throws IOException {
        return this.factory.getCompressorStream(new BufferedOutputStream(out));
    }

    public String toString() {
        return this.name + " compressed " + super.toString();
    }
}

