/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.Comment;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.grammars.CommentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class FileContents
implements CommentListener {
    private static final String MATCH_SINGLELINE_COMMENT_PAT = "^\\s*//.*$";
    private static final Pattern MATCH_SINGLELINE_COMMENT = Pattern.compile("^\\s*//.*$");
    private final String mFilename;
    private final String[] mLines;
    private final Map mJavadocComments = new HashMap();
    private final Map mCPlusPlusComments = new HashMap();
    private final Map mCComments = new HashMap();

    public FileContents(String aFilename, String[] aLines) {
        this.mFilename = aFilename;
        this.mLines = aLines;
    }

    public void reportSingleLineComment(String aType, int aStartLineNo, int aStartColNo) {
        this.reportCppComment(aStartLineNo, aStartColNo);
    }

    public void reportBlockComment(String aType, int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        this.reportCComment(aStartLineNo, aStartColNo, aEndLineNo, aEndColNo);
    }

    public void reportCppComment(int aStartLineNo, int aStartColNo) {
        String line = this.mLines[aStartLineNo - 1];
        String[] txt = new String[]{line.substring(aStartColNo)};
        Comment comment = new Comment(txt, aStartColNo, aStartLineNo, line.length() - 1);
        this.mCPlusPlusComments.put(new Integer(aStartLineNo), comment);
    }

    public Map getCppComments() {
        return Collections.unmodifiableMap(this.mCPlusPlusComments);
    }

    public void reportCComment(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        String[] cc = this.extractCComment(aStartLineNo, aStartColNo, aEndLineNo, aEndColNo);
        Comment comment = new Comment(cc, aStartColNo, aEndLineNo, aEndColNo);
        Integer key = new Integer(aStartLineNo);
        if (this.mCComments.containsKey(key)) {
            List entries = (List)this.mCComments.get(key);
            entries.add(comment);
        } else {
            ArrayList<Comment> entries = new ArrayList<Comment>();
            entries.add(comment);
            this.mCComments.put(key, entries);
        }
        if (this.mLines[aStartLineNo - 1].indexOf("/**", aStartColNo) != -1) {
            this.mJavadocComments.put(new Integer(aEndLineNo - 1), comment);
        }
    }

    public Map getCComments() {
        return Collections.unmodifiableMap(this.mCComments);
    }

    private String[] extractCComment(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        String[] retVal;
        if (aStartLineNo == aEndLineNo) {
            retVal = new String[]{this.mLines[aStartLineNo - 1].substring(aStartColNo, aEndColNo + 1)};
        } else {
            retVal = new String[aEndLineNo - aStartLineNo + 1];
            retVal[0] = this.mLines[aStartLineNo - 1].substring(aStartColNo);
            for (int i = aStartLineNo; i < aEndLineNo; ++i) {
                retVal[i - aStartLineNo + 1] = this.mLines[i];
            }
            retVal[retVal.length - 1] = this.mLines[aEndLineNo - 1].substring(0, aEndColNo + 1);
        }
        return retVal;
    }

    public TextBlock getJavadocBefore(int aLineNo) {
        int lineNo;
        for (lineNo = aLineNo - 2; lineNo > 0 && (this.lineIsBlank(lineNo) || this.lineIsComment(lineNo)); --lineNo) {
        }
        return (TextBlock)this.mJavadocComments.get(new Integer(lineNo));
    }

    public String[] getLines() {
        return this.mLines;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public boolean lineIsBlank(int aLineNo) {
        return "".equals(this.mLines[aLineNo].trim());
    }

    public boolean lineIsComment(int aLineNo) {
        return MATCH_SINGLELINE_COMMENT.matcher(this.mLines[aLineNo]).matches();
    }

    public boolean hasIntersectionWithComment(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        Collection values = this.mCComments.values();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            List row = (List)it.next();
            Iterator rowIterator = row.iterator();
            while (rowIterator.hasNext()) {
                TextBlock comment = (TextBlock)rowIterator.next();
                if (!comment.intersects(aStartLineNo, aStartColNo, aEndLineNo, aEndColNo)) continue;
                return true;
            }
        }
        for (int lineNumber = aStartLineNo; lineNumber <= aEndLineNo; ++lineNumber) {
            TextBlock comment = (TextBlock)this.mCPlusPlusComments.get(new Integer(lineNumber));
            if (comment == null || !comment.intersects(aStartLineNo, aStartColNo, aEndLineNo, aEndColNo)) continue;
            return true;
        }
        return false;
    }
}

