/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.daemon;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.cli.DaemonMavenCli;
import org.mvndaemon.mvnd.common.DaemonConnection;
import org.mvndaemon.mvnd.common.DaemonException;
import org.mvndaemon.mvnd.common.DaemonExpirationStatus;
import org.mvndaemon.mvnd.common.DaemonInfo;
import org.mvndaemon.mvnd.common.DaemonRegistry;
import org.mvndaemon.mvnd.common.DaemonState;
import org.mvndaemon.mvnd.common.DaemonStopEvent;
import org.mvndaemon.mvnd.common.Environment;
import org.mvndaemon.mvnd.common.Message;
import org.mvndaemon.mvnd.common.Os;
import org.mvndaemon.mvnd.common.SocketFamily;
import org.mvndaemon.mvnd.daemon.ClientDispatcher;
import org.mvndaemon.mvnd.daemon.Connection;
import org.mvndaemon.mvnd.daemon.DaemonExpiration;
import org.mvndaemon.mvnd.daemon.DaemonMemoryStatus;
import org.mvndaemon.mvnd.logging.smart.BuildEventListener;
import org.mvndaemon.mvnd.logging.smart.LoggingOutputStream;
import org.mvndaemon.mvnd.logging.smart.ProjectBuildLogAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class Server
implements AutoCloseable,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    public static final int CANCEL_TIMEOUT = 10000;
    private final String daemonId;
    private final boolean noDaemon;
    private final ServerSocketChannel socket;
    private final DaemonMavenCli cli;
    private volatile DaemonInfo info;
    private final DaemonRegistry registry;
    private final ScheduledExecutorService executor;
    private final DaemonExpiration.DaemonExpirationStrategy strategy;
    private final Lock expirationLock = new ReentrantLock();
    private final Lock stateLock = new ReentrantLock();
    private final Condition condition = this.stateLock.newCondition();
    private final DaemonMemoryStatus memoryStatus;
    private final long keepAliveMs;

    public Server() throws IOException {
        try {
            Signal.handle(new Signal("INT"), SignalHandler.SIG_IGN);
            if (Os.current() != Os.WINDOWS) {
                Signal.handle(new Signal("TSTP"), SignalHandler.SIG_IGN);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to ignore INT and TSTP signals", t);
        }
        this.daemonId = Environment.MVND_ID.asString();
        this.noDaemon = Environment.MVND_NO_DAEMON.asBoolean();
        this.keepAliveMs = Environment.MVND_KEEP_ALIVE.asDuration().toMillis();
        SocketFamily socketFamily = Environment.MVND_SOCKET_FAMILY.asOptional().map(SocketFamily::valueOf).orElse(SocketFamily.inet);
        try {
            this.cli = new DaemonMavenCli();
            this.registry = new DaemonRegistry(Environment.MVND_REGISTRY.asPath());
            this.socket = socketFamily.openServerSocket();
            this.executor = Executors.newScheduledThreadPool(1);
            this.strategy = DaemonExpiration.master();
            this.memoryStatus = new DaemonMemoryStatus(this.executor);
            SecureRandom secureRandom = new SecureRandom();
            byte[] token = new byte[16];
            secureRandom.nextBytes(token);
            ArrayList opts = new ArrayList();
            Arrays.stream(Environment.values()).filter(Environment::isDiscriminating).forEach(envKey -> envKey.asOptional().ifPresent(val -> opts.add(envKey.getProperty() + "=" + val)));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(opts.stream().collect(Collectors.joining("\n     ", "Initializing daemon with properties:\n     ", "\n")));
            }
            long cur = System.currentTimeMillis();
            this.info = new DaemonInfo(this.daemonId, Environment.MVND_JAVA_HOME.asString(), Environment.MVND_HOME.asString(), DaemonRegistry.getProcessId(), SocketFamily.toString((SocketAddress)this.socket.getLocalAddress()), token, Locale.getDefault().toLanguageTag(), opts, DaemonState.Busy, cur, cur);
            this.registry.store(this.info);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize " + Server.class.getName(), e);
        }
    }

    public DaemonMemoryStatus getMemoryStatus() {
        return this.memoryStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            try {
                this.updateState(DaemonState.Stopped);
            }
            finally {
                try {
                    this.executor.shutdown();
                }
                finally {
                    try {
                        this.registry.close();
                    }
                    finally {
                        try {
                            this.socket.close();
                        }
                        finally {
                            if (!this.noDaemon) {
                                this.clearCache("sun.net.www.protocol.jar.JarFileFactory", "urlCache");
                                this.clearCache("sun.net.www.protocol.jar.JarFileFactory", "fileCache");
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error closing daemon", t);
        }
    }

    public void clearCache(String clazzName, String fieldName) {
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(clazzName);
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            Map cache = (Map)f.get(null);
            cache.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: {
            try {
                Duration expirationCheckDelay = Environment.MVND_EXPIRATION_CHECK_DELAY.asDuration();
                this.executor.scheduleAtFixedRate(this::expirationCheck, expirationCheckDelay.toMillis(), expirationCheckDelay.toMillis(), TimeUnit.MILLISECONDS);
                LOGGER.info("Daemon started");
                if (this.noDaemon) {
                    try (SocketChannel socket = this.socket.accept();){
                        this.client(socket);
                        break block12;
                    }
                }
                new DaemonThread(this::accept).start();
                this.awaitStop();
            }
            catch (Throwable t) {
                LOGGER.error("Error running daemon loop", t);
            }
            finally {
                this.registry.remove(this.daemonId);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void accept() {
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                socket = this.socket.accept();
                try {
                    this.client(socket);
                }
                finally {
                    if (socket == null) continue;
                    socket.close();
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            Server.LOGGER.error("Error running daemon loop", t);
            return;
        }
        ** GOTO lbl-1000
    }

    private void client(SocketChannel socket) {
        LOGGER.info("Client connected");
        if (!this.checkToken(socket)) {
            LOGGER.error("Received invalid token, dropping connection");
            this.updateState(DaemonState.Idle);
            return;
        }
        try (DaemonConnection connection = new DaemonConnection(socket);){
            LOGGER.info("Waiting for request");
            SynchronousQueue request = new SynchronousQueue();
            new DaemonThread(() -> {
                Message message = connection.receive();
                request.offer(message);
            }).start();
            Message message = (Message)request.poll(1L, TimeUnit.MINUTES);
            if (message == null) {
                LOGGER.info("Could not receive request after one minute, dropping connection");
                this.updateState(DaemonState.Idle);
                return;
            }
            LOGGER.info("Request received: " + message);
            if (message instanceof Message.BuildRequest) {
                this.handle(connection, (Message.BuildRequest)message);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error reading request", t);
        }
    }

    private boolean checkToken(SocketChannel socket) {
        byte[] token = new byte[this.info.getToken().length];
        ByteBuffer tokenBuffer = ByteBuffer.wrap(token);
        try {
            while (socket.read(tokenBuffer) != -1 && tokenBuffer.remaining() > 0) {
            }
        }
        catch (IOException e) {
            LOGGER.debug("Discarding EOFException: {}", (Object)e.toString(), (Object)e);
        }
        return MessageDigest.isEqual(this.info.getToken(), token);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void expirationCheck() {
        if (!this.expirationLock.tryLock()) {
            LOGGER.warn("Previous DaemonExpirationPeriodicCheck was still running when the next run was scheduled.");
            return;
        }
        try {
            LOGGER.debug("Expiration check running");
            DaemonExpiration.DaemonExpirationResult result = this.strategy.checkExpiration(this);
            switch (result.getStatus()) {
                case DO_NOT_EXPIRE: {
                    return;
                }
                case QUIET_EXPIRE: {
                    this.requestStop(result.getReason());
                    return;
                }
                case GRACEFUL_EXPIRE: {
                    this.onExpire(result.getReason(), result.getStatus());
                    this.requestStop(result.getReason());
                    return;
                }
                case IMMEDIATE_EXPIRE: {
                    this.onExpire(result.getReason(), result.getStatus());
                    this.requestForcefulStop(result.getReason());
                    return;
                }
            }
            return;
        }
        catch (Throwable t) {
            LOGGER.error("Problem in daemon expiration check", t);
            if (!(t instanceof Error)) return;
            throw (Error)t;
        }
        finally {
            this.expirationLock.unlock();
        }
    }

    private void onExpire(String reason, DaemonExpirationStatus status) {
        LOGGER.debug("Storing daemon stop event: {}", (Object)reason);
        this.registry.storeStopEvent(new DaemonStopEvent(this.daemonId, System.currentTimeMillis(), status, reason));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean awaitStop() {
        this.stateLock.lock();
        try {
            while (true) {
                switch (this.getState()) {
                    case Idle: 
                    case Busy: {
                        LOGGER.debug("daemon is running. Sleeping until state changes.");
                        this.condition.await();
                        break;
                    }
                    case Canceled: {
                        this.cancelNow();
                        break;
                    }
                    case Broken: {
                        throw new IllegalStateException("This daemon is in a broken state.");
                    }
                    case StopRequested: {
                        LOGGER.debug("daemon stop has been requested. Sleeping until state changes.");
                        this.condition.await();
                        break;
                    }
                    case Stopped: {
                        LOGGER.debug("daemon has stopped.");
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            throw new DaemonException.InterruptedException((Throwable)e);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private void requestStop(String reason) {
        DaemonState state = this.getState();
        if (state != DaemonState.StopRequested && state != DaemonState.Stopped) {
            LOGGER.info("Daemon will be stopped at the end of the build " + reason);
            this.stateLock.lock();
            try {
                if (state == DaemonState.Busy) {
                    LOGGER.debug("Stop as soon as idle requested. The daemon is busy.");
                    this.beginStopping();
                } else {
                    this.stopNow(reason);
                }
            }
            finally {
                this.stateLock.unlock();
            }
        }
    }

    private void requestForcefulStop(String reason) {
        LOGGER.info("Daemon is stopping immediately " + reason);
        this.stopNow(reason);
    }

    private void beginStopping() {
        DaemonState state = this.getState();
        switch (state) {
            case Idle: 
            case Busy: 
            case Canceled: 
            case Broken: {
                this.updateState(DaemonState.StopRequested);
                break;
            }
            case StopRequested: 
            case Stopped: {
                break;
            }
            default: {
                throw new IllegalStateException("Daemon is in unexpected state: " + state);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stopNow(String reason) {
        this.stateLock.lock();
        try {
            DaemonState state = this.getState();
            switch (state) {
                case Idle: 
                case Busy: 
                case Canceled: 
                case Broken: 
                case StopRequested: {
                    LOGGER.debug("Marking daemon stopped due to {}. The daemon is running a build: {}", (Object)reason, (Object)(state == DaemonState.Busy ? 1 : 0));
                    this.updateState(DaemonState.Stopped);
                    return;
                }
                case Stopped: {
                    return;
                }
                default: {
                    throw new IllegalStateException("Daemon is in unexpected state: " + state);
                }
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    private void cancelNow() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(DaemonConnection connection, Message.BuildRequest buildRequest) {
        block16: {
            this.updateState(DaemonState.Busy);
            final PriorityBlockingQueue<Message> sendQueue = new PriorityBlockingQueue<Message>(64, Message.getMessageComparator());
            final LinkedBlockingDeque recvQueue = new LinkedBlockingDeque();
            ClientDispatcher buildEventListener = new ClientDispatcher(sendQueue);
            try (ProjectBuildLogAppender logAppender = new ProjectBuildLogAppender(buildEventListener);){
                LOGGER.info("Executing request");
                Thread sender = new Thread(() -> {
                    try {
                        boolean flushed = true;
                        while (true) {
                            Message m;
                            if (flushed) {
                                m = (Message)sendQueue.poll(this.keepAliveMs, TimeUnit.MILLISECONDS);
                                if (m == null) {
                                    m = Message.BareMessage.KEEP_ALIVE_SINGLETON;
                                }
                                flushed = false;
                            } else {
                                m = (Message)sendQueue.poll();
                                if (m == null) {
                                    connection.flush();
                                    flushed = true;
                                    continue;
                                }
                            }
                            if (m == Message.BareMessage.STOP_SINGLETON) {
                                connection.flush();
                                LOGGER.info("No more message to dispatch");
                                return;
                            }
                            LOGGER.info("Dispatch message: " + m);
                            connection.dispatch(m);
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.error("Error dispatching events", t);
                        return;
                    }
                });
                sender.start();
                Thread receiver = new Thread(() -> {
                    try {
                        while (true) {
                            Message message;
                            if ((message = connection.receive()) == null) {
                                return;
                            }
                            LOGGER.info("Received message: {}", (Object)message);
                            if (message == Message.BareMessage.CANCEL_BUILD_SINGLETON) {
                                this.updateState(DaemonState.Canceled);
                                return;
                            }
                            BlockingQueue blockingQueue = recvQueue;
                            synchronized (blockingQueue) {
                                recvQueue.put(message);
                                recvQueue.notifyAll();
                            }
                        }
                    }
                    catch (DaemonException.RecoverableMessageIOException t) {
                        this.updateState(DaemonState.Canceled);
                        return;
                    }
                    catch (Throwable t) {
                        this.updateState(DaemonState.Broken);
                        LOGGER.error("Error receiving events", t);
                    }
                });
                receiver.start();
                try {
                    Connection.setCurrent(new Connection(){

                        @Override
                        public void dispatch(Message message) {
                            try {
                                sendQueue.put(message);
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        @Override
                        public <T extends Message> T request(Message request, Class<T> responseType, Predicate<T> matcher) {
                            try {
                                BlockingQueue blockingQueue = recvQueue;
                                synchronized (blockingQueue) {
                                    sendQueue.put(request);
                                    LOGGER.info("Waiting for response");
                                    while (true) {
                                        Message t;
                                        if ((t = (Message)recvQueue.stream().filter(responseType::isInstance).map(responseType::cast).filter(matcher).findFirst().orElse(null)) != null) {
                                            recvQueue.remove(t);
                                            LOGGER.info("Received response: {}", (Object)t);
                                            return (T)t;
                                        }
                                        recvQueue.wait();
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    System.setOut(new LoggingOutputStream(s -> sendQueue.add((Message)Message.out((String)s))).printStream());
                    System.setErr(new LoggingOutputStream(s -> sendQueue.add((Message)Message.err((String)s))).printStream());
                    int exitCode = this.cli.main(buildRequest.getArgs(), buildRequest.getWorkingDir(), buildRequest.getProjectDir(), buildRequest.getEnv(), buildEventListener);
                    LOGGER.info("Build finished, finishing message dispatch");
                    ((BuildEventListener)buildEventListener).finish(exitCode);
                }
                catch (Throwable t) {
                    try {
                        LOGGER.error("Error while building project", t);
                        ((BuildEventListener)buildEventListener).fail(t);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        sender.join();
                        ProjectBuildLogAppender.setProjectId(null);
                    }
                }
                sender.join();
                ProjectBuildLogAppender.setProjectId(null);
            }
            catch (Throwable t) {
                LOGGER.error("Error while building project", t);
            }
            finally {
                if (!this.noDaemon) {
                    LOGGER.info("Daemon back to idle");
                    this.updateState(DaemonState.Idle);
                    System.gc();
                }
            }
        }
    }

    private void updateState(DaemonState state) {
        if (this.getState() != state) {
            LOGGER.info("Updating state to: " + state);
            this.stateLock.lock();
            try {
                this.info = this.info.withState(state);
                this.registry.store(this.info);
                this.condition.signalAll();
            }
            finally {
                this.stateLock.unlock();
            }
        }
    }

    public DaemonRegistry getRegistry() {
        return this.registry;
    }

    public DaemonInfo getInfo() {
        return this.info;
    }

    public String getDaemonId() {
        return this.info.getId();
    }

    public DaemonState getState() {
        return this.info.getState();
    }

    public long getLastIdle() {
        return this.info.getLastIdle();
    }

    public long getLastBusy() {
        return this.info.getLastBusy();
    }

    public String toString() {
        return this.info.toString();
    }

    static class DaemonThread
    extends Thread {
        public DaemonThread(Runnable target) {
            super(target);
        }
    }
}

