/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.collation;

import com.ibm.icu.text.CollationElementIterator;
import com.ibm.icu.text.RuleBasedCollator;
import org.basex.query.util.collation.Collation;
import org.basex.util.InputInfo;
import org.basex.util.Token;

final class UCACollation
extends Collation {
    private static final int PRIMARY_ORDER_MASK = UCACollation.mask(0);
    private final RuleBasedCollator collator;
    private final int strength;
    private final int strengthMask;
    private final boolean isShifted;
    private final int variableTop;

    UCACollation(RuleBasedCollator collator) {
        this.collator = collator;
        this.strength = this.collator.getStrength();
        this.strengthMask = UCACollation.mask(this.strength);
        this.isShifted = this.collator.isAlternateHandlingShifted();
        this.variableTop = this.collator.getVariableTop();
    }

    private static int mask(int strength) {
        return switch (strength) {
            case 0 -> -65536;
            case 1 -> -256;
            default -> -1;
        };
    }

    @Override
    public int compare(byte[] string, byte[] compare) {
        return this.collator.compare(Token.string(string), Token.string(compare));
    }

    @Override
    protected int indexOf(String string, String contains, Collation.Mode mode, InputInfo ii) {
        CollationElementIterator iterS = this.collator.getCollationElementIterator(string);
        CollationElementIterator iterC = this.collator.getCollationElementIterator(contains);
        int elemC = this.next(iterC);
        if (elemC == -1) {
            return 0;
        }
        int offC = iterC.getOffset();
        while (true) {
            int elemS;
            if ((elemS = this.next(iterS)) != elemC) {
                if (elemS != -1 && mode != Collation.Mode.STARTS_WITH) continue;
                return -1;
            }
            int offS = iterS.getOffset();
            if (this.startsWith(iterS, iterC)) {
                if (mode == Collation.Mode.INDEX_AFTER) {
                    return iterS.getOffset();
                }
                if (mode == Collation.Mode.ENDS_WITH) {
                    if (this.next(iterS) == -1) {
                        return offS - 1;
                    }
                } else {
                    return offS - 1;
                }
            }
            iterS.setOffset(offS);
            iterC.setOffset(offC);
        }
    }

    @Override
    public byte[] key(byte[] string, InputInfo info) {
        return this.collator.getCollationKey(Token.string(string)).toByteArray();
    }

    private boolean startsWith(CollationElementIterator string, CollationElementIterator sub) {
        int s;
        do {
            if ((s = this.next(sub)) != -1) continue;
            return true;
        } while (s == this.next(string));
        return false;
    }

    private int next(CollationElementIterator it) {
        int c;
        do {
            if ((c = it.next()) == -1) {
                return c;
            }
            c &= this.strengthMask;
            if (this.isShifted) {
                if (this.variableTop <= c) continue;
                if (this.strength >= 3) {
                    c &= PRIMARY_ORDER_MASK;
                    continue;
                }
                c = 0;
                continue;
            }
            if (this.strength < 3 || c != 0) continue;
            c = 65535;
        } while (c == 0);
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof UCACollation)) return false;
        UCACollation uca = (UCACollation)obj;
        if (!this.collator.equals((Object)uca.collator)) return false;
        return true;
    }
}

