/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

#ifndef ISCSI_PROTO_H
#define ISCSI_PROTO_H

#define ISCSI_DRAFT20_VERSION	0x00

/* default iSCSI listen port for incoming connections */
#define ISCSI_LISTEN_PORT	3260

/* Padding word length */
#define PAD_WORD_LEN		4

/*
 * useful common(control and data pathes) macro
 */
#define ntoh24(p) (((p)[0] << 16) | ((p)[1] << 8) | ((p)[2]))
#define hton24(p, v) { \
        p[0] = (((v) >> 16) & 0xFF); \
        p[1] = (((v) >> 8) & 0xFF); \
        p[2] = ((v) & 0xFF); \
}
#define zero_data(p) {p[0]=0;p[1]=0;p[2]=0;}

/*
 * iSCSI Template Message Header
 */
struct iscsi_hdr {
	vmk_uint8		opcode;
	vmk_uint8		flags;		/* Final bit */
	vmk_uint8		rsvd2[2];
	vmk_uint8		hlength;	/* AHSs total length */
	vmk_uint8		dlength[3];	/* Data length */
	vmk_uint8		lun[8];
	/*__be32*/vmk_uint32		itt;		/* Initiator Task Tag */
	/*__be32*/vmk_uint32		ttt;		/* Target Task Tag */
	/*__be32*/vmk_uint32		statsn;
	/*__be32*/vmk_uint32		exp_statsn;
	/*__be32*/vmk_uint32		max_statsn;
	vmk_uint8		other[12];
};

/************************* RFC 3720 Begin *****************************/

#define ISCSI_RESERVED_TAG		0xffffffff

/* Opcode encoding bits */
#define ISCSI_OP_RETRY			0x80
#define ISCSI_OP_IMMEDIATE		0x40
#define ISCSI_OPCODE_MASK		0x3F

/* Initiator Opcode values */
#define ISCSI_OP_NOOP_OUT		0x00
#define ISCSI_OP_SCSI_CMD		0x01
#define ISCSI_OP_SCSI_TMFUNC		0x02
#define ISCSI_OP_LOGIN			0x03
#define ISCSI_OP_TEXT			0x04
#define ISCSI_OP_SCSI_DATA_OUT		0x05
#define ISCSI_OP_LOGOUT			0x06
#define ISCSI_OP_SNACK			0x10

#define ISCSI_OP_VENDOR1_CMD		0x1c
#define ISCSI_OP_VENDOR2_CMD		0x1d
#define ISCSI_OP_VENDOR3_CMD		0x1e
#define ISCSI_OP_VENDOR4_CMD		0x1f

/* Target Opcode values */
#define ISCSI_OP_NOOP_IN		0x20
#define ISCSI_OP_SCSI_CMD_RSP		0x21
#define ISCSI_OP_SCSI_TMFUNC_RSP	0x22
#define ISCSI_OP_LOGIN_RSP		0x23
#define ISCSI_OP_TEXT_RSP		0x24
#define ISCSI_OP_SCSI_DATA_IN		0x25
#define ISCSI_OP_LOGOUT_RSP		0x26
#define ISCSI_OP_R2T			0x31
#define ISCSI_OP_ASYNC_EVENT		0x32
#define ISCSI_OP_REJECT			0x3f

struct iscsi_ahs_hdr {
	/*__be16*/vmk_uint16 ahslength;
	vmk_uint8 ahstype;
	vmk_uint8 ahspec[5];
};

#define ISCSI_AHSTYPE_CDB		1
#define ISCSI_AHSTYPE_RLENGTH		2

/* iSCSI PDU Header */
struct iscsi_cmd {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	/*__be16*/vmk_uint16 rsvd2;
	vmk_uint8 hlength;
	vmk_uint8 dlength[3];
	vmk_uint8 lun[8];
	/*__be32*/vmk_uint32 itt;	/* Initiator Task Tag */
	/*__be32*/vmk_uint32 data_length;
	/*__be32*/vmk_uint32 cmdsn;
	/*__be32*/vmk_uint32 exp_statsn;
	vmk_uint8 cdb[16];	/* SCSI Command Block */
	/* Additional Data (Command Dependent) */
};

/* Command PDU flags */
#define ISCSI_FLAG_CMD_FINAL		0x80
#define ISCSI_FLAG_CMD_READ		0x40
#define ISCSI_FLAG_CMD_WRITE		0x20
#define ISCSI_FLAG_CMD_ATTR_MASK	0x07	/* 3 bits */

/* SCSI Command Attribute values */
#define ISCSI_ATTR_UNTAGGED		0
#define ISCSI_ATTR_SIMPLE		1
#define ISCSI_ATTR_ORDERED		2
#define ISCSI_ATTR_HEAD_OF_QUEUE	3
#define ISCSI_ATTR_ACA			4

struct iscsi_rlength_ahdr {
	/*__be16*/vmk_uint16 ahslength;
	vmk_uint8 ahstype;
	vmk_uint8 reserved;
	/*__be32*/vmk_uint32 read_length;
};

/* SCSI Response Header */
struct iscsi_cmd_rsp {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 response;
	vmk_uint8 cmd_status;
	vmk_uint8 hlength;
	vmk_uint8 dlength[3];
	vmk_uint8 rsvd[8];
	/*__be32*/vmk_uint32	itt;	/* Initiator Task Tag */
	/*__be32*/vmk_uint32	rsvd1;
	/*__be32*/vmk_uint32	statsn;
	/*__be32*/vmk_uint32	exp_cmdsn;
	/*__be32*/vmk_uint32	max_cmdsn;
	/*__be32*/vmk_uint32	exp_datasn;
	/*__be32*/vmk_uint32	bi_residual_count;
	/*__be32*/vmk_uint32	residual_count;
	/* Response or Sense Data (optional) */
};

/* Command Response PDU flags */
#define ISCSI_FLAG_CMD_BIDI_OVERFLOW	0x10
#define ISCSI_FLAG_CMD_BIDI_UNDERFLOW	0x08
#define ISCSI_FLAG_CMD_OVERFLOW		0x04
#define ISCSI_FLAG_CMD_UNDERFLOW	0x02

/* iSCSI Status values. Valid if Rsp Selector bit is not set */
#define ISCSI_STATUS_CMD_COMPLETED	0
#define ISCSI_STATUS_TARGET_FAILURE	1
#define ISCSI_STATUS_SUBSYS_FAILURE	2

/* Asynchronous Event Header */
struct iscsi_async {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 rsvd2[2];
	vmk_uint8 rsvd3;
	vmk_uint8 dlength[3];
	vmk_uint8 lun[8];
	vmk_uint8 rsvd4[8];
	/*__be32*/vmk_uint32	statsn;
	/*__be32*/vmk_uint32	exp_cmdsn;
	/*__be32*/vmk_uint32	max_cmdsn;
	vmk_uint8 async_event;
	vmk_uint8 async_vcode;
	/*__be16*/vmk_uint16	param1;
	/*__be16*/vmk_uint16	param2;
	/*__be16*/vmk_uint16	param3;
	vmk_uint8 rsvd5[4];
};

/* iSCSI Event Codes */
#define ISCSI_ASYNC_MSG_SCSI_EVENT			0
#define ISCSI_ASYNC_MSG_REQUEST_LOGOUT			1
#define ISCSI_ASYNC_MSG_DROPPING_CONNECTION		2
#define ISCSI_ASYNC_MSG_DROPPING_ALL_CONNECTIONS	3
#define ISCSI_ASYNC_MSG_PARAM_NEGOTIATION		4
#define ISCSI_ASYNC_MSG_VENDOR_SPECIFIC			255

/* NOP-Out Message */
struct iscsi_nopout {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	/*__be16*/vmk_uint16	rsvd2;
	vmk_uint8 rsvd3;
	vmk_uint8 dlength[3];
	vmk_uint8 lun[8];
	/*__be32*/vmk_uint32	itt;	/* Initiator Task Tag */
	/*__be32*/vmk_uint32	ttt;	/* Target Transfer Tag */
	/*__be32*/vmk_uint32	cmdsn;
	/*__be32*/vmk_uint32	exp_statsn;
	vmk_uint8 rsvd4[16];
};

/* NOP-In Message */
struct iscsi_nopin {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	/*__be16*/vmk_uint16	rsvd2;
	vmk_uint8 rsvd3;
	vmk_uint8 dlength[3];
	vmk_uint8 lun[8];
	/*__be32*/vmk_uint32	itt;	/* Initiator Task Tag */
	/*__be32*/vmk_uint32	ttt;	/* Target Transfer Tag */
	/*__be32*/vmk_uint32	statsn;
	/*__be32*/vmk_uint32	exp_cmdsn;
	/*__be32*/vmk_uint32	max_cmdsn;
	vmk_uint8 rsvd4[12];
};

/* SCSI Task Management Message Header */
struct iscsi_tm {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 rsvd1[2];
	vmk_uint8 hlength;
	vmk_uint8 dlength[3];
	vmk_uint8 lun[8];
	/*__be32*/vmk_uint32	itt;	/* Initiator Task Tag */
	/*__be32*/vmk_uint32	rtt;	/* Reference Task Tag */
	/*__be32*/vmk_uint32	cmdsn;
	/*__be32*/vmk_uint32	exp_statsn;
	/*__be32*/vmk_uint32	refcmdsn;
	/*__be32*/vmk_uint32	exp_datasn;
	vmk_uint8 rsvd2[8];
};

#define ISCSI_FLAG_TM_FUNC_MASK			0x7F

/* Function values */
#define ISCSI_TM_FUNC_ABORT_TASK		1
#define ISCSI_TM_FUNC_ABORT_TASK_SET		2
#define ISCSI_TM_FUNC_CLEAR_ACA			3
#define ISCSI_TM_FUNC_CLEAR_TASK_SET		4
#define ISCSI_TM_FUNC_LOGICAL_UNIT_RESET	5
#define ISCSI_TM_FUNC_TARGET_WARM_RESET		6
#define ISCSI_TM_FUNC_TARGET_COLD_RESET		7
#define ISCSI_TM_FUNC_TASK_REASSIGN		8
#define ISCSI_TM_FUNC_VIRT_RESET		9

/* SCSI Task Management Response Header */
struct iscsi_tm_rsp {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 response;	/* see Response values below */
	vmk_uint8 qualifier;
	vmk_uint8 hlength;
	vmk_uint8 dlength[3];
	vmk_uint8 rsvd2[8];
	/*__be32*/vmk_uint32	itt;	/* Initiator Task Tag */
	/*__be32*/vmk_uint32	rtt;	/* Reference Task Tag */
	/*__be32*/vmk_uint32	statsn;
	/*__be32*/vmk_uint32	exp_cmdsn;
	/*__be32*/vmk_uint32	max_cmdsn;
	vmk_uint8 rsvd3[12];
};

/* Response values */
#define ISCSI_TMF_RSP_COMPLETE		0x00
#define ISCSI_TMF_RSP_NO_TASK		0x01
#define ISCSI_TMF_RSP_NO_LUN		0x02
#define ISCSI_TMF_RSP_TASK_ALLEGIANT	0x03
#define ISCSI_TMF_RSP_NO_FAILOVER	0x04
#define ISCSI_TMF_RSP_NOT_SUPPORTED	0x05
#define ISCSI_TMF_RSP_AUTH_FAILED	0x06
#define ISCSI_TMF_RSP_REJECTED		0xff

/* Ready To Transfer Header */
struct iscsi_r2t_rsp {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 rsvd2[2];
	vmk_uint8	hlength;
	vmk_uint8	dlength[3];
	vmk_uint8 lun[8];
	/*__be32*/vmk_uint32	itt;	/* Initiator Task Tag */
	/*__be32*/vmk_uint32	ttt;	/* Target Transfer Tag */
	/*__be32*/vmk_uint32	statsn;
	/*__be32*/vmk_uint32	exp_cmdsn;
	/*__be32*/vmk_uint32	max_cmdsn;
	/*__be32*/vmk_uint32	r2tsn;
	/*__be32*/vmk_uint32	data_offset;
	/*__be32*/vmk_uint32	data_length;
};

/* SCSI Data Hdr */
struct iscsi_data {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 rsvd2[2];
	vmk_uint8 rsvd3;
	vmk_uint8 dlength[3];
	vmk_uint8 lun[8];
	/*__be32*/vmk_uint32	itt;
	/*__be32*/vmk_uint32	ttt;
	/*__be32*/vmk_uint32	rsvd4;
	/*__be32*/vmk_uint32	exp_statsn;
	/*__be32*/vmk_uint32	rsvd5;
	/*__be32*/vmk_uint32	datasn;
	/*__be32*/vmk_uint32	offset;
	/*__be32*/vmk_uint32	rsvd6;
	/* Payload */
};

/* SCSI Data Response Hdr */
struct iscsi_data_rsp {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 rsvd2;
	vmk_uint8 cmd_status;
	vmk_uint8 hlength;
	vmk_uint8 dlength[3];
	vmk_uint8 lun[8];
	/*__be32*/vmk_uint32	itt;
	/*__be32*/vmk_uint32	ttt;
	/*__be32*/vmk_uint32	statsn;
	/*__be32*/vmk_uint32	exp_cmdsn;
	/*__be32*/vmk_uint32	max_cmdsn;
	/*__be32*/vmk_uint32	datasn;
	/*__be32*/vmk_uint32	offset;
	/*__be32*/vmk_uint32	residual_count;
};

/* Data Response PDU flags */
#define ISCSI_FLAG_DATA_ACK		0x40
#define ISCSI_FLAG_DATA_OVERFLOW	0x04
#define ISCSI_FLAG_DATA_UNDERFLOW	0x02
#define ISCSI_FLAG_DATA_STATUS		0x01

/* Text Header */
struct iscsi_text {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 rsvd2[2];
	vmk_uint8 hlength;
	vmk_uint8 dlength[3];
	vmk_uint8 rsvd4[8];
	/*__be32*/vmk_uint32	itt;
	/*__be32*/vmk_uint32	ttt;
	/*__be32*/vmk_uint32	cmdsn;
	/*__be32*/vmk_uint32	exp_statsn;
	vmk_uint8 rsvd5[16];
	/* Text - key=value pairs */
};

#define ISCSI_FLAG_TEXT_CONTINUE	0x40

/* Text Response Header */
struct iscsi_text_rsp {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 rsvd2[2];
	vmk_uint8 hlength;
	vmk_uint8 dlength[3];
	vmk_uint8 rsvd4[8];
	/*__be32*/vmk_uint32	itt;
	/*__be32*/vmk_uint32	ttt;
	/*__be32*/vmk_uint32	statsn;
	/*__be32*/vmk_uint32	exp_cmdsn;
	/*__be32*/vmk_uint32	max_cmdsn;
	vmk_uint8 rsvd5[12];
	/* Text Response - key:value pairs */
};

/* Login Header */
struct iscsi_login {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 max_version;	/* Max. version supported */
	vmk_uint8 min_version;	/* Min. version supported */
	vmk_uint8 hlength;
	vmk_uint8 dlength[3];
	vmk_uint8 isid[6];	/* Initiator Session ID */
	/*__be16*/vmk_uint16	tsih;	/* Target Session Handle */
	/*__be32*/vmk_uint32	itt;	/* Initiator Task Tag */
	/*__be16*/vmk_uint16	cid;
	/*__be16*/vmk_uint16	rsvd3;
	/*__be32*/vmk_uint32	cmdsn;
	/*__be32*/vmk_uint32	exp_statsn;
	vmk_uint8 rsvd5[16];
};

/* Login PDU flags */
#define ISCSI_FLAG_LOGIN_TRANSIT		0x80
#define ISCSI_FLAG_LOGIN_CONTINUE		0x40
#define ISCSI_FLAG_LOGIN_CURRENT_STAGE_MASK	0x0C	/* 2 bits */
#define ISCSI_FLAG_LOGIN_NEXT_STAGE_MASK	0x03	/* 2 bits */

#define ISCSI_LOGIN_CURRENT_STAGE(flags) \
	((flags & ISCSI_FLAG_LOGIN_CURRENT_STAGE_MASK) >> 2)
#define ISCSI_LOGIN_NEXT_STAGE(flags) \
	(flags & ISCSI_FLAG_LOGIN_NEXT_STAGE_MASK)

/* Login Response Header */
struct iscsi_login_rsp {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 max_version;	/* Max. version supported */
	vmk_uint8 active_version;	/* Active version */
	vmk_uint8 hlength;
	vmk_uint8 dlength[3];
	vmk_uint8 isid[6];	/* Initiator Session ID */
	/*__be16*/vmk_uint16	tsih;	/* Target Session Handle */
	/*__be32*/vmk_uint32	itt;	/* Initiator Task Tag */
	/*__be32*/vmk_uint32	rsvd3;
	/*__be32*/vmk_uint32	statsn;
	/*__be32*/vmk_uint32	exp_cmdsn;
	/*__be32*/vmk_uint32	max_cmdsn;
	vmk_uint8 status_class;	/* see Login RSP ststus classes below */
	vmk_uint8 status_detail;	/* see Login RSP Status details below */
	vmk_uint8 rsvd4[10];
};

/* Login stage (phase) codes for CSG, NSG */
#define ISCSI_INITIAL_LOGIN_STAGE		-1
#define ISCSI_SECURITY_NEGOTIATION_STAGE	0
#define ISCSI_OP_PARMS_NEGOTIATION_STAGE	1
#define ISCSI_FULL_FEATURE_PHASE		3

/* Login Status response classes */
#define ISCSI_STATUS_CLS_SUCCESS		0x00
#define ISCSI_STATUS_CLS_REDIRECT		0x01
#define ISCSI_STATUS_CLS_INITIATOR_ERR		0x02
#define ISCSI_STATUS_CLS_TARGET_ERR		0x03

/* Login Status response detail codes */
/* Class-0 (Success) */
#define ISCSI_LOGIN_STATUS_ACCEPT		0x00

/* Class-1 (Redirection) */
#define ISCSI_LOGIN_STATUS_TGT_MOVED_TEMP	0x01
#define ISCSI_LOGIN_STATUS_TGT_MOVED_PERM	0x02

/* Class-2 (Initiator Error) */
#define ISCSI_LOGIN_STATUS_INIT_ERR		0x00
#define ISCSI_LOGIN_STATUS_AUTH_FAILED		0x01
#define ISCSI_LOGIN_STATUS_TGT_FORBIDDEN	0x02
#define ISCSI_LOGIN_STATUS_TGT_NOT_FOUND	0x03
#define ISCSI_LOGIN_STATUS_TGT_REMOVED		0x04
#define ISCSI_LOGIN_STATUS_NO_VERSION		0x05
#define ISCSI_LOGIN_STATUS_ISID_ERROR		0x06
#define ISCSI_LOGIN_STATUS_MISSING_FIELDS	0x07
#define ISCSI_LOGIN_STATUS_CONN_ADD_FAILED	0x08
#define ISCSI_LOGIN_STATUS_NO_SESSION_TYPE	0x09
#define ISCSI_LOGIN_STATUS_NO_SESSION		0x0a
#define ISCSI_LOGIN_STATUS_INVALID_REQUEST	0x0b

/* Class-3 (Target Error) */
#define ISCSI_LOGIN_STATUS_TARGET_ERROR		0x00
#define ISCSI_LOGIN_STATUS_SVC_UNAVAILABLE	0x01
#define ISCSI_LOGIN_STATUS_NO_RESOURCES		0x02

/* Logout Header */
struct iscsi_logout {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 rsvd1[2];
	vmk_uint8 hlength;
	vmk_uint8 dlength[3];
	vmk_uint8 rsvd2[8];
	/*__be32*/vmk_uint32	itt;	/* Initiator Task Tag */
	/*__be16*/vmk_uint16	cid;
	vmk_uint8 rsvd3[2];
	/*__be32*/vmk_uint32	cmdsn;
	/*__be32*/vmk_uint32	exp_statsn;
	vmk_uint8 rsvd4[16];
};

/* Logout PDU flags */
#define ISCSI_FLAG_LOGOUT_REASON_MASK	0x7F

/* logout reason_code values */

#define ISCSI_LOGOUT_REASON_CLOSE_SESSION	0
#define ISCSI_LOGOUT_REASON_CLOSE_CONNECTION	1
#define ISCSI_LOGOUT_REASON_RECOVERY		2
#define ISCSI_LOGOUT_REASON_AEN_REQUEST		3

/* Logout Response Header */
struct iscsi_logout_rsp {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 response;	/* see Logout response values below */
	vmk_uint8 rsvd2;
	vmk_uint8 hlength;
	vmk_uint8 dlength[3];
	vmk_uint8 rsvd3[8];
	/*__be32*/vmk_uint32	itt;	/* Initiator Task Tag */
	/*__be32*/vmk_uint32	rsvd4;
	/*__be32*/vmk_uint32	statsn;
	/*__be32*/vmk_uint32	exp_cmdsn;
	/*__be32*/vmk_uint32	max_cmdsn;
	/*__be32*/vmk_uint32	rsvd5;
	/*__be16*/vmk_uint16	t2wait;
	/*__be16*/vmk_uint16	t2retain;
	/*__be32*/vmk_uint32	rsvd6;
};

/* logout response status values */

#define ISCSI_LOGOUT_SUCCESS			0
#define ISCSI_LOGOUT_CID_NOT_FOUND		1
#define ISCSI_LOGOUT_RECOVERY_UNSUPPORTED	2
#define ISCSI_LOGOUT_CLEANUP_FAILED		3

/* SNACK Header */
struct iscsi_snack {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 rsvd2[14];
	/*__be32*/vmk_uint32	itt;
	/*__be32*/vmk_uint32	begrun;
	/*__be32*/vmk_uint32	runlength;
	/*__be32*/vmk_uint32	exp_statsn;
	/*__be32*/vmk_uint32	rsvd3;
	/*__be32*/vmk_uint32	exp_datasn;
	vmk_uint8 rsvd6[8];
};

/* SNACK PDU flags */
#define ISCSI_FLAG_SNACK_TYPE_MASK	0x0F	/* 4 bits */

/* Reject Message Header */
struct iscsi_reject {
	vmk_uint8 opcode;
	vmk_uint8 flags;
	vmk_uint8 reason;
	vmk_uint8 rsvd2;
	vmk_uint8 hlength;
	vmk_uint8 dlength[3];
	vmk_uint8 rsvd3[8];
	/*__be32*/vmk_uint32  ffffffff;
	vmk_uint8 rsvd4[4];
	/*__be32*/vmk_uint32	statsn;
	/*__be32*/vmk_uint32	exp_cmdsn;
	/*__be32*/vmk_uint32	max_cmdsn;
	/*__be32*/vmk_uint32	datasn;
	vmk_uint8 rsvd5[8];
	/* Text - Rejected hdr */
};

/* Reason for Reject */
#define ISCSI_REASON_CMD_BEFORE_LOGIN	1
#define ISCSI_REASON_DATA_DIGEST_ERROR	2
#define ISCSI_REASON_DATA_SNACK_REJECT	3
#define ISCSI_REASON_PROTOCOL_ERROR	4
#define ISCSI_REASON_CMD_NOT_SUPPORTED	5
#define ISCSI_REASON_IMM_CMD_REJECT		6
#define ISCSI_REASON_TASK_IN_PROGRESS	7
#define ISCSI_REASON_INVALID_SNACK		8
#define ISCSI_REASON_BOOKMARK_INVALID	9
#define ISCSI_REASON_BOOKMARK_NO_RESOURCES	10
#define ISCSI_REASON_NEGOTIATION_RESET	11

/* Max. number of Key=Value pairs in a text message */
#define MAX_KEY_VALUE_PAIRS	8192

/* maximum length for text keys/values */
#define KEY_MAXLEN		64
#define VALUE_MAXLEN		255
#define TARGET_NAME_MAXLEN	VALUE_MAXLEN

#define DEFAULT_MAX_RECV_DATA_SEGMENT_LENGTH	8192

/************************* RFC 3720 End *****************************/

#endif /* ISCSI_PROTO_H */
