#
# identification section
#
qfle3f_identification = {
   "name"            : "qfle3f",
   "module type"     : "device driver",
   "binary compat"   : "yes",
   "summary"         : "QLogic E3 Native FC driver",
   "description"     : "QLogic E3 Native FC driver",
# Versioning:
# Major no. to represent OS 1: ESX65
# Sub Major no. to represent Major SW feature
# Minor no. to represent driver release
# Sub Minor no. to represent driver patch release
   "version"         : "1.0.68.0",
   "license"         : "QLogic_Proprietary",
   "vendor"          : "QLogic",
   "vendor_code"     : "QLC",
   "vendor_email"    : "support@qlogic.com",
}

#
# Build the Driver Module
#
module_def = {
   "identification"  : qfle3f_identification,
   "source files"    : [ "qfle3f_main.c",
			 "qfle3f_fcoe.c",
			 "qfle3f_els.c",
			 "qfle3f_hwi.c",
			 "qfle3f_io.c",
			 "qfle3f_scsi.c",
			 "qfle3f_npiv.c",
			 "qfle3f_target.c",
             "qfle3f_attr.c",
			 "qfle3f_vmk.c",
			 "qfle3f_key_val.c",
			 "qfle3f_vmkmgmt.c",
			 "qfle3f_debug.c",
             "ql_fcoe_mgmt/ql_fcoe.c",
             "ql_fcoe_mgmt/ql_fcoe_disc.c",
             "ql_fcoe_mgmt/ql_fcoe_exch.c",
             "ql_fcoe_mgmt/ql_fcoe_driver_cmd.c",
             "ql_fcoe_mgmt/ql_fcoe_session.c",
             "ql_fcoe_mgmt/ql_fcoe_fabric.c",
             "ql_fcoe_mgmt/ql_fcoe_queue.c",
             "ql_fcoe_mgmt/ql_fcoe_helper.c",
             "ql_fcoe_mgmt/FCoE_Framing.c",
                       ],
   "cc flags"	     : [
#			 "-Wno-unused-variable",
#			 "-Wno-unused-function",
			 "-DCNIC_STORAGE_IF",
		       ],
   "cc defs"         : [
			 # For vmk_ScsiSchedCommandCompletion.
			 # Remove when PR 956728 is fixed.
			 "VMK_DEVKIT_HAS_API_VMKAPI_MPP",
			# Macro for ESX DDK version
			"VMWARE_ESX_DDK_VERSION=65000",
			"__FCOE_IF_RESTART_WQ__",
			"ATTACH_WITH_E3",
			"__VMKLNX__",
			"QL_FCOE",
			"NPIV_SUPPORT",
			# Extended Debugging Macros
			# "DBG_WORK",
			# "DBG",
			# "FCOEDBG_ENABLE_TRACE_FABRIC_REF",
			# "FCOEDBG_ENABLE_TRACE_SESS_REF",
		       ],
}
qfle3f_module = defineKernelModule(module_def)

#
# Build the Driver's Device Definition
#
device_def = {
	"identification"	: qfle3f_identification,
	"device spec"		: "qfle3f_devices.py",
}
qfle3f_device_def = defineDeviceSpec(device_def)

#
# Build the VIB
#
qfle3f_vib_def = {
   "identification"  : qfle3f_identification,
   "payload"         : [ qfle3f_module,
			 qfle3f_device_def,
                       ],
   "vib properties"  : {
      "urls"                    : [ ],
      "provides"                : [	],
      "depends"                 : [{'name': 'vmkapi_2_2_0_0'}],
      "conflicts"               : [ ],
      "replaces"                : [ ],
      "maintenance-mode"        : True,
      "live-install-allowed"    : False,
      "live-remove-allowed"     : False,
      "stateless-ready"         : True,
      "acceptance-level"        : 'certified',
   }
}
qfle3f_vib =  defineModuleVib(qfle3f_vib_def)

#
# Build the Offline Bundle
#
qfle3f_bulletin_def = {
   "identification" : qfle3f_identification,
   "vib"            : qfle3f_vib,
   "bulletin" : {
      # These elements show the default values for the corresponding items in bulletin.xml file
      # Uncomment a line if you need to use a different value
      #'severity'    : 'general',
      #'category'    : 'Enhancement',
      #'releaseType' : 'extension',
      #'urgency'     : 'Important',

      'kbUrl'       : 'http://kb.vmware.com/kb/example.html',

      # 1. At least one target platform needs to be specified with 'productLineID'
      # 2. The product version number may be specified explicitly, like 7.8.9,
      # or, when it's None or skipped, be a default one for the devkit
      # 3. 'locale' element is optional
      'platforms'   : [ {'productLineID':'ESXi'},
      #                 {'productLineID':'ESXi', 'version':"7.8.9", 'locale':''}
                      ]
   }
}
qfle3f_bundle =  defineOfflineBundle(qfle3f_bulletin_def)
