/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

/*
 * qfle3f.h: QLogic 10 Gigabit ESX Ethernet FCoE offload driver.
 *
 */

#ifndef QFLE3F_H
#define QFLE3F_H

#include "57xx_hsi_qfle3.h"
//#include "qlevfc_ioctl.h"

#include <vmkapi.h>

#include "ql_fcoe_mgmt/ql_fcoe.h"
#include "ql_fcoe_mgmt/FC_2.h"
#include "ql_fcoe_mgmt/ql_fcoe_helper.h"
#include "ql_fcoe_mgmt/ql_fcoe_session.h"
#include "ql_fcoe_mgmt/ql_fcoe_fabric.h"
#include "ql_fcoe_mgmt/FC_FCP.h"

#include "qfle3f_debug.h"
#include "qfle3f_vmk.h"

#include "qcnic_if.h"
#include "qfle3_ecore_mfw_req.h"

#define QFLE3F_HEAP_INITIAL_SIZE (4 * 1024 * 1024)
#define QFLE3F_HEAP_MAXIMUM_SIZE (128 * 1024 * 1024)

#define __LITTLE_ENDIAN


#define DRV_MODULE_NAME     "qfle3f"
#define DRV_MODULE_RELDATE  "JUL 16, 2016"

extern int qfle3f_queue_depth;
extern int qfle3f_enable_r_a_tov;
extern int qfle3f_r_a_tov;
extern int qfle3f_create_vmkMgmt_Entry;
extern int qfle3f_user_overwrote_devloss_val;
extern int qfle3f_devloss_tmo;
extern int qfle3f_default_vlan;

extern int num_hosts;

/*
 * Multi-function modes
 */
enum mf_mode {
	SINGLE_FUNCTION,
	MULTI_FUNCTION_SD,
	MULTI_FUNCTION_SI,
	MULTI_FUNCTION_AFEX,
	MAX_MF_MODE};

enum mf_sub_mode {
	SUB_MF_MODE_FFA = 0,
	SUB_MF_MODE_UFP
};

#define WWN_SIZE	8	/* Size of WWPN, WWN & WWNN */

/* SV: XXX: Borrowed from non-native. To be removed later. */
#define NETDEV_UP           0x0001
#define NETDEV_DOWN         0x0002
#define NETDEV_GOING_DOWN   0x0009

#define ETH_P_FCOE      0x8906          /* FCOE ether type */
#define ETH_P_FIP       0x8914          /* FIP ether type */

#define MAX_HBA 2048
#include "57xx_fcoe_constants.h"

#define BYTES_PER_WORD				0x04

#define FCOE_FIP_OPCODE_DISC		0x01
#define FCOE_FIP_OPCODE_LS			0x02
#define FCOE_FIP_OPCODE_CTRL		0x03
#define FCOE_FIP_OPCODE_VLAN		0x04
#define FCOE_FIP_OPCODE_VN2VN		0x05
#define FCOE_FIP_OPCODE_VENDOR_MIN	0xfff8
#define FCOE_FIP_OPCODE_VENDOR_MAX	0xfffe

/* Subcodes for opcode : FCOE_FIP_OPCODE_LS */
#define FCOE_LS_SUBCODE_REQUEST		0x01
#define FCOE_LS_SUBCODE_RESPONSE	0x02

/* Subcodes for opcode : FCOE_FIP_OPCODE_VLAN */
#define FCOE_VLAN_SUBCODE_REQUEST		0x01
#define FCOE_VLAN_SUBCODE_RESPONSE		0x02

/* FIP Flags */
#define FCOE_FIP_SUPPORTS_FPMA			0x8000
#define FCOE_FIP_SUPPORTS_SPMA			0x4000
#define FCOE_FIP_REC_OR_P2P				0x4000
#define FCOE_FIP_AVAILABLE				0x4000
#define FCOE_FIP_SOLICITED				0x4000
#define FCOE_FIP_SEND_FPORT				0x4000

#define FCOE_FIP_DESC_MAC_ADDRESS			0x02
#define FCOE_FIP_DESC_NAME_IDENTIFIER		0x04
#define FCOE_FIP_DESC_FLOGI					0x08
#define FCOE_FIP_DESCVXPORT_IDENTIFIER		0x0B
#define FCOE_FIP_DESC_VLAN					0x0E

#define QFLE3F_DRIVER_NAME		"qfle3f"
#define PFX			"qfle3f: "

#ifndef DEFINE_PCI_DEVICE_TABLE
#define DEFINE_PCI_DEVICE_TABLE(_table) struct pci_device_id _table[]
#endif
#ifndef PCI_DEVICE_ID_NX2_57712
#define PCI_DEVICE_ID_NX2_57712		0x1662
#endif
#ifndef PCI_DEVICE_ID_NX2_57712E
#define PCI_DEVICE_ID_NX2_57712E	0x1663
#endif
#ifndef PCI_DEVICE_ID_NX2_57800
#define PCI_DEVICE_ID_NX2_57800		0x168a
#endif
#ifndef PCI_DEVICE_ID_NX2_57800_MF
#define PCI_DEVICE_ID_NX2_57800_MF	0x16a5
#endif
#ifndef PCI_DEVICE_ID_NX2_57810
#define PCI_DEVICE_ID_NX2_57810		0x168e
#endif
#ifndef PCI_DEVICE_ID_NX2_57810_MF
#define PCI_DEVICE_ID_NX2_57810_MF	0x16ae
#endif
#ifndef PCI_DEVICE_ID_NX2_57840_4_10
#define PCI_DEVICE_ID_NX2_57840_4_10    0x16a1
#endif
#ifndef PCI_DEVICE_ID_NX2_57840_2_20
#define PCI_DEVICE_ID_NX2_57840_2_20    0x16a2
#endif
#ifndef PCI_DEVICE_ID_NX2_57840_MF
#define PCI_DEVICE_ID_NX2_57840_MF      0x16a4
#endif

/*
 *  On ESX the vmk_CPUMemFenceWrite() instruction is defined to only a compiler barrier
 *  The macro vmk_CPUMemFenceWrite() need to be overrode to properly synchronize memory
 */
#if defined(__VMKLNX__)
#undef vmk_CPUMemFenceWrite
#define vmk_CPUMemFenceWrite()   asm volatile("sfence" ::: "memory")
#endif

#define BNX2X_DB_SHIFT				3
#define BNX2X_DOORBELL_PCI_BAR                  2

#define QFLE3F_MAX_BD_LEN		0xffff
#define QFLE3F_BD_SPLIT_SZ		0x8000
#define QFLE3F_MAX_BDS_PER_CMD		256
#define MAX_PAGES_PER_EXCHG_CTX_POOL	1024

#define QFLE3F_SQ_WQES_MAX	1024

#define QFLE3F_SCSI_MAX_SQES	((3 * QFLE3F_SQ_WQES_MAX) / 8)
#define QFLE3F_TM_MAX_SQES	((QFLE3F_SQ_WQES_MAX) / 2)
#define QFLE3F_ELS_MAX_SQES	(QFLE3F_TM_MAX_SQES - 1)

#define QFLE3F_RQ_WQES_MAX	16
#define QFLE3F_CQ_WQES_MAX	(QFLE3F_SQ_WQES_MAX + QFLE3F_RQ_WQES_MAX)

#define QFLE3F_MAX_SESS		2048
#define QFLE3F_NUM_MAX_SESS_LOG	7 // log base 2 of QFLE3_FCOE_NUM_CONNECTIONS

#ifdef __VMKLNX__
#define QFLE3F_MAX_OUTSTANDING_CMNDS	2048
#define QFLE3F_INITIAL_POOLSIZE         ((1 * VMK_MEGABYTE) >> VMK_PAGE_SHIFT)
#define QFLE3F_MAX_POOLSIZE_5771X       ((24 * VMK_MEGABYTE) >> VMK_PAGE_SHIFT)
#else	/* __VMKLNX__ */
#ifdef CONFIG_X86_64
#define QFLE3F_MAX_OUTSTANDING_CMNDS	4096
#else
#define QFLE3F_MAX_OUTSTANDING_CMNDS	1024
#endif
#endif	/* __VMKLNX__ */

/* NPIV: Macros */
#define QFLE3F_MAX_PHBA	8
#define QFLE3F_MAX_NPIV	64
#define QFLE3F_NPIV_INVALID 0xFFFFFFFF
#define QFLE3F_MAX_HBAS	(QFLE3F_MAX_NPIV + QFLE3F_MAX_PHBA)

#define QFLE3F_MIN_PAYLOAD		256
#define QFLE3F_MAX_PAYLOAD		2048

#define QFLE3F_RQ_BUF_SZ		256
#define QFLE3F_RQ_BUF_LOG_SZ	8 // log base 2 of QFLE3F_RQ_BUF_SZ

#define QFLE3F_SQ_WQE_SIZE		(sizeof(struct fcoe_sqe))
#define QFLE3F_CQ_WQE_SIZE		(sizeof(struct fcoe_cqe))
#define QFLE3F_RQ_WQE_SIZE		(QFLE3F_RQ_BUF_SZ)
#define QFLE3F_LCQ_WQE_SIZE		(sizeof(struct fcoe_lcqe))
#define QFLE3F_XFERQ_WQE_SIZE		(sizeof(struct fcoe_xfrqe))
#define QFLE3F_CONFQ_WQE_SIZE		(sizeof(struct fcoe_confqe))
#define QFLE3F_5771X_DB_VMK_PAGE_SIZE	128

#define QFLE3F_MAX_TASKS		QFLE3F_MAX_OUTSTANDING_CMNDS
#define QFLE3F_TASK_SIZE		128
/*#define QFLE3F_TASK_SIZE		(sizeof(struct fcoe_task_ctx_entry)) */
#define	QFLE3F_TASKS_PER_PAGE		(VMK_PAGE_SIZE/QFLE3F_TASK_SIZE)
#define QFLE3F_TASK_CTX_ARR_SZ		(QFLE3F_MAX_TASKS/QFLE3F_TASKS_PER_PAGE)

#define QFLE3F_MAX_ROWS_IN_HASH_TBL	8
#define QFLE3F_HASH_TBL_CHUNK_SIZE	(16 * 1024)

#define QFLE3F_MAX_SEQS			255
#define QFLE3F_MAX_RETRY_CNT		3
#define QFLE3F_MAX_RPORT_RETRY_CNT	255

#define QFLE3F_READ			(1 << 1)
#define QFLE3F_WRITE			(1 << 0)

#define QFLE3F_MIN_XID			0
#define QFLE3F_MAX_XID			(QFLE3F_MAX_OUTSTANDING_CMNDS - 1)
#define FCOE_MIN_XID			(QFLE3F_MAX_OUTSTANDING_CMNDS)
#define FCOE_MAX_XID		\
			(QFLE3F_MAX_OUTSTANDING_CMNDS + (nr_cpu_ids * 256))
#define QFLE3F_MAX_LUN			0xFFFF
#define QFLE3F_MAX_FCP_TGT		256
#define QFLE3F_MAX_CMD_LEN		16

#define QFLE3F_TM_TIMEOUT		10	/* secs  */
#define QFLE3F_IO_TIMEOUT		20000UL	/* msecs */

#define QFLE3F_WAIT_CNT			120
#define QFLE3F_FW_TIMEOUT		3

#define PORT_MAX			2

#define CMD_SCSI_STATUS(Cmnd)		((Cmnd)->SCp.Status)

/* FC FCP Status */
#define	FC_GOOD				0

#define QFLE3F_RNID_HBA			0x7


#define QFLE3F_MIN_PAYLOAD              256
#define QFLE3F_MAX_PAYLOAD              2048
#define QFLE3F_MFS                      \
                        (QFLE3F_MAX_PAYLOAD + sizeof(FC_FRAME_HEADER))
#define QFLE3F_MINI_JUMBO_MTU           2500

#define QFLE3F_RELOGIN_WAIT_TIME        1000
#define QFLE3F_RELOGIN_WAIT_CNT         10

#define QFLE3F_SYM_NAME_LEN		16

#define FC_PORTSPEED_20GBIT 0x80

#ifndef SUPPORTED_20000baseKR2_Full
#define SUPPORTED_20000baseKR2_Full (1 << 22)
#endif

#ifndef SPEED_20000
#define SPEED_20000 20000
#endif

enum qfle3f_lock_rank_t{
        QFLE3F_LOW_LOCK_RANK = 1,
        QFLE3F_HIGH_LOCK_RANK,
};

struct fcoe_ctlr {
    int type;

};

#if 0
/*
 * FCP_CMND IU Payload.
 */
struct fcp_cmnd {
	vmk_uint8		qfc_lun[8];	/* logical unit number */
	vmk_uint8		qfc_cmdref;	/* commmand reference number */
	vmk_uint8		qfc_pri_ta;	/* priority and task attribute */
	vmk_uint8		qfc_tm_flags;	/* task management flags */
	vmk_uint8		qfc_flags;	/* additional len & flags */
	vmk_uint8		qfc_cdb[16];	/* base CDB */
	/*vmk_uint32*/vmk_uint32		qfc_dl;		/* data length (must follow qfc_cdb) */
};
#endif

#define	FCP_CMND_LEN	32	/* expected length of structure */

#define INVALID_EXCHANGE_IDENTIFIER		0xffff

#define QL_CPU_TO_LE8(x)	(x)
#define QL_CPU_TO_LE16(x)	(x)
#define QL_CPU_TO_LE32(x)	(x)
#define QL_CPU_TO_LE64(x)	(x)

/*
 *  * I/O register
 *   */

#define RD_REG_BYTE(addr)       *((volatile vmk_uint8 *) (addr))
#define RD_REG_WORD(addr)       *((volatile vmk_uint16 *) (addr))
#define RD_REG_DWORD(addr)      *((volatile vmk_uint32 *) (addr))
#define RD_REG_QWORD(addr)      *((volatile vmk_uint64 *) (addr))
#define WRT_REG_BYTE(addr, data)    *((volatile vmk_uint8 *)(addr)) = (data)
#define WRT_REG_WORD(addr, data)    *((volatile vmk_uint16 *)(addr)) = (data)
#define WRT_REG_DWORD(addr, data)   *((volatile vmk_uint32 *)(addr)) = (data)
#define WRT_REG_QWORD(addr, data)   *((volatile vmk_uint64 *)(addr)) = (data)

/* NPIV: */
typedef enum {
	HBA_PHYSICAL,
	HBA_VIRTUAL,
} hba_type_t;

typedef struct qfle3fHBA {
	vmk_ListLinks 		link;
	struct cnic_dev 		*cnic;

	struct qfle3fCommandManager 		*commandManager;
	ql_vmk_singlethread_workqueue_t *timerWorkQueue;

    vmk_ScsiAdapter *scsiAdapter;
    vmk_Device vmkScsiAdapterDevice;

    vmk_uint32 initiator_targetPortID;
    vmk_uint32 vlanID;

	struct ql_fcoe_adapter *qlfcoeAdapter;

/* DMA Constraints */
#define QFLE3F_DMA_SG_MAXENTRIES      1270
#define QFLE3F_DMA_SG_ELEMALIGNMENT   0
#define QFLE3F_DMA_SG_ELEMSIZEMULT    0
#define QFLE3F_DMA_SG_ELEMMAXSIZE     0xffffffff
#define QFLE3F_DMA_SG_MAXXFER         0xffffffff
#define QFLE3F_DMA_SG_ELEMSTRADDLE    VMK_ADDRESS_MASK_32BIT+1
#define QFLE3F_DMA_SG_ADDRMASK        VMK_ADDRESS_MASK_64BIT

    vmk_DMAEngine ioDMAEngine;

	/* Active list of offloaded sessions */
	struct qfle3f_rport *targetOffloadList[QFLE3_FCOE_NUM_CONNECTIONS];
	int num_ofld_sess;

	struct fcoe_task_ctx_entry **taskContext;

	vmk_atomic64			kref;
	vmk_Lock 			hbaLock;
	vmk_Semaphore		hbaMutex;
	vmk_BitVector		*hbaState;
		#define ADAPTER_STATE_UP		0
		#define ADAPTER_STATE_GOING_DOWN	1
		#define ADAPTER_STATE_LINK_DOWN		2
		#define ADAPTER_STATE_READY		3
		#define ADAPTER_STATE_QUIESCE	4
		#define ADAPTER_STATE_DETACH	5
		#define ADAPTER_STATE_VPORT_DELETE	6
		#define ADAPTER_STATE_INIT_FAILED	31
	vmk_BitVector *flags;
		#define QFLE3F_FLAG_DESTROY_CMPL	1
		#define QFLE3F_FLAG_UNLOADING			2
	vmk_BitVector *flags2;
		#define QFLE3F_CNIC_REGISTERED          1
		#define QFLE3F_VLAN_ENABLED		2
		#define QFLE3F_CNA_QUEUES_ALLOCED	3
		#define QFLE3F_VLAN_TIMEOUT		4
		#define QFLE3F_NPIV_SUPPORTED	5
		#define QFLE3F_NPIV_PREBOOT		6

	vmk_BitVector *initDone;
		#define QFLE3F_FW_INIT_DONE		0
		#define QFLE3F_CTLR_INIT_DONE		1
		#define QFLE3F_CREATE_DONE		2
		#define QFLE3F_DISC_DONE		3

    /* This is the vmk_Device passed as a parameter in qfle3f attach function */
    vmk_Device deviceCreatedByCnicDriver;
    /* This is the vmk_Device with which NIC attach function is called */
    vmk_Device nicDevice;

    int qDepth;
	//vmk_PCIDeviceID *pdev;
	vmk_PCIDevice pdev;
    vmk_PCIDeviceAddr vmk_pci_addr;
	vmk_PCIDeviceID	pdev_id;

#define QFC_DEV_LOSS_TMO		20
#define QFC_MIN_DEV_LOSS_TMO	1
#define QFC_MAX_DEV_LOSS_TMO	120
	vmk_uint32 devLossTimeout;
#if 0
	struct net_device 		*netdev;
	struct net_device 		*phys_dev;
#ifdef __VMKLNX__
	struct net_device 		*fcoe_net_dev;
#endif
#endif

	struct fcoe_ctlr ctlr;
	vmk_uint8 dataSourceMacAddress[VMK_ETH_ADDR_LENGTH];
	vmk_uint8 grantedMacAddress[VMK_ETH_ADDR_LENGTH];
	vmk_uint8 ffaFCoEMacAddress[VMK_ETH_ADDR_LENGTH];
#define QFLE3F_ADAPTER_FFA			1
#define QFLE3F_ADAPTER_BOOT			2
	vmk_BitVector *hbaType;
	vmk_uint32 vlan_id;  /* This is now in target->Sess->Fabric->vlan_and_pri */
    /* Set bit means the conn_id is free */
    vmk_HashTable connIdHashTable;

	struct qla_dmamem taskContextDMA[QFLE3F_TASK_CTX_ARR_SZ];
	struct regpair *taskContextBDTable;
	struct qla_dmamem taskContextBDDMA;

	int hashTableSegmentCount;
	void **hashTableSegments;
	struct qla_dmamem **hashTableSegmentsDMA;
	void *hashTablePBL;
	struct qla_dmamem hashTablePBLDMA;
	struct fcoe_t2_hash_table_entry *t2HashTable;
	struct qla_dmamem t2HashTable_dma;
	char *t2HashTablePointer;
	struct qla_dmamem t2HashTablePointer_dma;

	const char *vmhbaName;
	int host_no;
	char *dummyBuffer;
	struct qla_dmamem dummyBufferDMA;

	struct fcoe_statistics_params *statsBuffer;
	struct qla_dmamem statsBufferDMA;
#ifdef __FCOE_IF_RESTART_WQ__
	ql_vmk_singlethread_delayed_workitem_t fcoeDiscoveryWork; /* timer for ULP timeouts */
#endif

	/*
	 * PCI related info.
	 */
	vmk_uint16 pci_did;
	vmk_uint16 pci_vid;
	vmk_uint16 pci_sdid;
	vmk_uint16 pci_svid;
	vmk_uint16 pci_func;
	vmk_uint16 pci_devno;

	vmk_ListLinks scsiScanList;
	vmk_Lock scsiScanListLock;
	vmk_WorldID scsiScanWorldID;
	vmk_atomic64 wakeupPending;
	vmk_atomic64 pollwakeupPending;
	vmk_Semaphore vportMutex;

#if 0
	vmk_WorldID*l2_thread;
	vmk_PktHandle_head fcoe_rx_list;
#endif

	/* linkdown handling */
	vmk_WorldEventID shutdownWait;
	int wait_for_link_down;

	/*destroy handling */
	vmk_WorldEventID destroyFunctionEvent;
	vmk_WorldEventID allUploadWait;

	/* statistics */
	vmk_WorldEventID statRequestDone;
    vmk_Bool statRequestCompleted;
	struct fcoe_capabilities fcoeCapabilities;
#ifdef __VMKLNX__
	//vmk_MemPool qfle3f_dma_pool;
#endif

	vmk_uint64 vlanGroupUnsetDropStat;
	vmk_uint64 vlanInvalidDropStat;
	vmk_uint32 numberMaxFrags;

	vmk_uint64 cnaInitializeQueue;
	vmk_uint64 cnaCleanupQueue;

#if 0
	struct packet_type 		fcoe_packet_type;
	struct packet_type 		fip_packet_type;
#endif

#ifdef __FCOE_IF_RESTART_WQ__
	ql_vmk_singlethread_workqueue_t *fcoeInterfaceRestartWorkQueue;
#endif

    vmk_PCIDeviceID *vmk_pci_dev_id;
    //vmk_PCIDevice vmk_pci_device;

	int io_cmpl_abort_race;
	//int ffa_cvl_fix;
	//int ffa_cvl_fix_alloc;
	//int ffa_cvl_fix_alloc_err;

	char sym_name[QFLE3F_SYM_NAME_LEN];	/* Symbolic Name */

	vmk_PktHandle *last_recv_skb;
	vmk_uint64 drop_d_id_mismatch;
	vmk_uint64 drop_fpma_mismatch;
	vmk_uint64 drop_vn_port_zero;
	vmk_uint64 drop_wrong_source_mac;
	vmk_PktHandle *last_vn_port_zero;
	vmk_uint64 drop_abts_seq_ex_ctx_set;
	ql_vmk_singlethread_workqueue_t *vlanDiscoveryTimeoutWorkQueue;

    vmk_MgmtHandle kvMgmtHandle;
    vmk_Bool mgmtKeyAdded;

	vmk_Lock    ioctl_cmpl_lock;
	struct qla_dmamem ioctl_mem_phys;
	void *ioctl_mem;
	vmk_uint16  cmpl_done;
	vmk_uint16  ioctl_cmpl_sem;
	vmk_uint8 SCSIPT_InProgress;
	vmk_atomic64 ioctl_cmd_count;

	vmk_Name vmnicName;

#if 0
	struct delayed_work vlan_disc_timeout_work;
#endif
	vmk_uint32 instance;
    vmk_Bool ioAllowed;
#if 0
	struct Scsi_Host *host;
	vmk_WorldEventID scsi_pass_comp;
#endif
    void *ioctlMemPhysical;
	void *ioctlMem;
	vmk_Semaphore ioctlMutex;
    /* FDMI Related attributes */
	vmk_WorldID backgroundThread;
	struct qfle3f_port *port;
	vmk_Lock backgroundMutex;
#if 0
	struct workqueue_struct		*els_timeout_wq;
	struct delayed_work els_timeout_work; /* timer for ULP timeouts */
#endif
    int FDMICurrentState;
#define	ZERO_STATE              0x0
#define	BEGIN_PROCESS           0x1
#define	PLOGI_SEND_MGMT_SERVER  0x2
#define	RHBA_FDMI2              0x3
#define	RHBA_FDMI               0x4
#define	RPA_SMARTSAN_FDMI2      0x5
#define	RPA_FDMI2               0x6
#define	RPA_FDMI                0x7
#define	ALL_DONE                0xff

	/* NPIV fields. */
	hba_type_t 			type;
	/* NPIV: Only used by phba */
	vmk_ListLinks 		vportList;
	vmk_Lock			vportListLck;
	vmk_uint32			vportsInUse;
	vmk_uint32			vp_id;
	struct qfle3fHBA    *vhba_address[QFLE3F_MAX_NPIV];
	/* NPIV: Only used by vhba */
	struct qfle3fHBA 	*phba;
	vmk_uint64			wwpn;
	vmk_uint64			wwnn;
	vmk_WorldID			flogiPollWorldID;
	/* SV: TODO: Improve on memory needed for below fields. */
	vmk_uint8			tag[16];
	vmk_uint8			virtualName[64];
	int num_rport;

	vmk_uint64			logoLogoRace;

#ifdef IOERROR_DEBUGGING
	vmk_uint64 ioRetrySessNotReady;
	vmk_uint64 ioRetryCmdAllocFailed;
	vmk_uint64 ioRetrypostIOReqFailed;
#endif

	vmk_uint8                   fpma[VMK_MAX_ETHERNET_MAC_LENGTH];
	vmk_uint8                   fcf_mac[VMK_MAX_ETHERNET_MAC_LENGTH];
} qfle3fHBA_t;

struct qfle3f_port {
	struct qfle3fHBA *hba;
	//struct fc_lport *lport;

#if 0
	vmk_Timer timer;
	struct work_struct destroy_work;
	vmk_PktHandle_head fcoe_pending_queue;
	struct device 			dummy_dev;
#endif
	vmk_uint8 fcoe_pending_queue_active;
	// vmk_uint8 dataSourceMacAddress[VMK_ETH_ADDR_LENGTH];
};


#define qfle3f_from_ctlr(fip) 	container_of(fip, struct qfle3fHBA, ctlr)
struct qfle3fCommandManager {
	struct qfle3fHBA *hba;
	vmk_Lock commandManagerLock;
	vmk_uint16 nextIndex;
	struct qfle3fCommand *qfle3fCommandPool;
	vmk_ListLinks freeList;
	struct io_bdt **io_bdt_pool;
	struct qfle3fCommand **cmds;
};

typedef enum {
    FCT_UNKNOWN,
    FCT_RSCN,
    FCT_SWITCH,
    FCT_BROADCAST,
    FCT_INITIATOR,
    FCT_TARGET
} fc_portType_t;

enum qfle3f_rportState {
	QFLE3F_RPORT_ST_INIT,
	QFLE3F_RPORT_ST_OFFLOADED,
	QFLE3F_RPORT_ST_EXPL_LOGO,
	QFLE3F_RPORT_ST_DISABLED,
	QFLE3F_RPORT_ST_DEV_LOSS,
	QFLE3F_RPORT_ST_BLOCK_SCSI_REQUESTS
};

struct qfle3fFCLun {
    vmk_ListLinks list;

    struct qfle3f_rport *target;

    vmk_uint8 deviceType;
    vmk_atomic64 state;
    vmk_uint32 flags;
    unsigned long ioCnt;    /* total xfer count since boot */
    int qDepth;

    int vmkChannel;
    int vmkTargetId;
    int vmkLunId;
};

struct qfle3f_rport {
	//struct qfle3f_port *port;
	//struct fc_rport *rport;
	//struct fc_rport_priv *rdata;
	struct qfle3fHBA *hba;

	vmk_atomic64 state; // enum qfle3f_rportState

	vmk_Lock fclunsListLock;
	vmk_ListLinks fcluns;

#define DPM_TRIGER_TYPE		0x40
	vmk_uint32 fcoe_conn_id;
	vmk_uint32 contextID;
	vmk_uint32 initiatorPortID;		// Initiator Port id
	vmk_uint32 targetPortID;	// Target Port id

	vmk_uint8 portType;
	// This is the connection id and target id
	vmk_uint32 vmk_targetID;
	vmk_uint32 vmk_channel;

	vmk_BitVector *flags;
#define QFLE3F_FLAG_SESSION_READY	0x1
#define QFLE3F_FLAG_OFFLOADED		0x2
#define QFLE3F_FLAG_DISABLED		0x3
#define QFLE3F_FLAG_DESTROYED		0x4
#define QFLE3F_FLAG_OFLD_REQ_CMPL	0x5
#define QFLE3F_FLAG_CTX_ALLOC_FAILURE	0x6
#define QFLE3F_FLAG_UPLD_REQ_COMPL	0x7
#define QFLE3F_FLAG_EXPL_LOGO		0x8
#define QFLE3F_FLAG_DISABLE_FAILED	0x9
#define QFLE3F_FLAG_DEV_LOSS    	0x10
#define QFLE3F_FLAG_LOGO_REQ_PENDING	0x11
#define QFLE3F_FLAG_MAX_SIZE		0x20

    vmk_Timer devLossTimer;

	vmk_uint32 maxSendQueues;
	vmk_uint32 maxCompletionQueues;
	vmk_atomic64 freeSendQueues;

	struct ql_fcoe_session *Sess;

	vmk_ListLinks scsiScanList;

	struct b577xx_doorbell_set_prod sq_db;
	vmk_uint64 ctx_base;

	struct fcoe_sqe *sq;
	struct fcoe_sqe *currentSendQueue;
	vmk_uint16 sendQueueProducerIndex;
	vmk_uint16 sendQueueCurrentToggleBit;
	vmk_uint32 sqMemSize;

	struct fcoe_cqe *cq;
	vmk_uint16 completionQueueConstIndex;
	vmk_uint16 completionQueueCurrentToggleBit;
	vmk_uint32 cqMemSize;

	vmk_Lock completionQueueLock;

	vmk_ListLinks activeCommands;

	vmk_Lock targetLock;
	vmk_atomic64 num_active_ios;
	vmk_uint32 flushInProgress;
	vmk_ListLinks elsQueue;
	vmk_ListLinks ioRetireQueue;
	vmk_ListLinks activeTaskManagementQueue;
	vmk_ListLinks abtsQueue;

	vmk_Lock commandListLock;

	vmk_atomic64 refcount;
#if 0
	vmk_Timer ofldTimer;
#endif
	//wait_queue_head_t ofldWait;
	vmk_WorldEventID offloadWait;

	vmk_Timer upldTimer;
	//wait_queue_head_t uploadWait;
	vmk_WorldEventID uploadWait;

	/* Fixed Attributes */
	vmk_uint32 maxFrameSize;
	vmk_uint32 supportedClasses;

	vmk_uint64 nodeName;
	vmk_uint64 portName;
	vmk_uint32 roles;

	vmk_uint8 portState;	/* Will only be ONLINE or UNKNOWN */
	vmk_uint32 fastIOFailTimeout;

	struct qla_dmamem cqDMA;
	struct qla_dmamem sqDMA;

	struct b577xx_fcoe_rx_doorbell rxDb;
	vmk_uint32 maxRequestQueues;

	void *rq;
	struct qla_dmamem rqDMA;
	vmk_uint32 receiveQueueProducerIndex;
	vmk_uint32 receiveQueueConsumerIndex;
	vmk_uint32 rqMemSize;

	void *rqPbl;
	struct qla_dmamem rqPblDMA;
	vmk_uint32 rqPblSize;

	struct fcoe_xfrqe *xferq;
	struct qla_dmamem xferqDMA;
	vmk_uint32 xferqMemSize;

	struct fcoe_confqe *confq;
	struct qla_dmamem confqDMA;
	vmk_uint32 confqMemSize;

	void *confqPbl;
	struct qla_dmamem confqPblDMA;
	vmk_uint32 confqPblSize;

	struct fcoe_conn_db *connDb;
	struct qla_dmamem connDbDMA;
	vmk_uint32 connDbMemSize;

	struct fcoe_sqe *lcq;
	struct qla_dmamem lcqDMA;
	vmk_uint32 lcqMemSize;

	void *ofldReq[4];
	struct qla_dmamem ofldReqDMA[4];
	void *enblReq;
	struct qla_dmamem enblReqDMA;

#ifdef IOERROR_DEBUGGING
	vmk_uint64 ioRetrySessNotReady;
	vmk_uint64 ioRetryCmdAllocFailed;
	vmk_uint64 ioRetrypostIOReqFailed;
#endif
};

struct qfle3f_mp_req {
	vmk_uint8 tm_flags;

	vmk_uint32 req_len;
	void *req_buf;
	struct qla_dmamem req_buf_dma;
	struct fcoe_bd_ctx *mp_req_bd;
	struct qla_dmamem mp_req_bd_dma;
	FC_FRAME_HEADER req_fc_hdr;

	vmk_uint32 resp_len;
	void *resp_buf;
	struct qla_dmamem resp_buf_dma;
	struct fcoe_bd_ctx *mp_resp_bd;
	struct qla_dmamem mp_resp_bd_dma;
	FC_FRAME_HEADER resp_fc_hdr;
};

struct qfle3f_els_cb_arg {
	struct qfle3fCommand *abortedIORequest;
	struct qfle3fCommand *ioRequest;
	vmk_uint16 l2_oxid;
};

/* qfle3f command structure */
struct qfle3fCommand {
	vmk_ListLinks link;
	struct qfle3fHBA *vhba;
	struct qfle3f_rport *target;
	vmk_ScsiCommand *sc_cmd;
	struct qfle3fCommandManager *commandManager;

	vmk_uint16 xid;
	vmk_uint32 on_active_queue;
	vmk_uint32 on_tmf_queue;
	vmk_uint32 cmd_type;
#define QFLE3F_SCSI_CMD 		1
#define QFLE3F_TASK_MGMT_CMD 		2
#define QFLE3F_ABTS			3
#define QFLE3F_ELS			4
#define QFLE3F_CLEANUP			5
	vmk_uint32 ioRequest_flags;

	struct qfle3fFCLun *fclun;

	vmk_atomic64 refcount;
	struct fcoe_task_ctx_entry *task;
	struct io_bdt *bd_tbl;
	vmk_uint64 data_xfer_len;

	ql_vmk_singlethread_delayed_workitem_t timeout_work; /* timer for ULP timeouts */

	void (*cb_func)(struct qfle3f_els_cb_arg *cb_arg);
	struct qfle3f_els_cb_arg *cb_arg;
	vmk_WorldEventID tm_done;
	vmk_atomic64 tm_done_invoked;
	int 	wait_for_comp;

	struct fcp_rsp *rsp;
	vmk_BitVector *req_flags;
#define QFLE3F_FLAG_ABTS_OR_CLNUP_PEN	0x0
#define QFLE3F_FLAG_ISSUE_RRQ		0x1
#define QFLE3F_FLAG_ISSUE_ABTS		0x2
#define QFLE3F_FLAG_ABTS_DONE		0x3
#define QFLE3F_FLAG_TM_COMPL		0x4
#define QFLE3F_FLAG_TM_TIMEOUT		0x5
#define QFLE3F_FLAG_IO_CLEANUP		0x6
#define QFLE3F_FLAG_RETIRE_OXID		0x7
#define	QFLE3F_FLAG_EH_ABORT		0x8
#define QFLE3F_FLAG_IO_COMPL		0x9
#define QFLE3F_FLAG_ELS_DONE		0xa
#define QFLE3F_FLAG_ELS_TIMEOUT		0xb

#define QFLE3F_FLAG_REQ_FLAGS_MAX	0x20
	vmk_uint32 fcp_resid;
	vmk_uint32 fcp_rsp_len;
	vmk_uint32 fcp_sns_len;
	vmk_uint8 cdb_status; /* SCSI IO status */
	vmk_uint8 fcp_status; /* FCP IO status */
	vmk_uint8 fcp_rsp_code;
	vmk_uint8 scsi_comp_flags;

	vmk_uint16 ioctl_flags;

	struct qfle3f_mp_req mp_req;

#define QFLE3F_CLEANUP_TMO		(30)
	/* Timer to track cleanup-cmd submitted to fw. */
	vmk_Timer cleanup_tmr;
#define CLEANUP_TIMER_ACTIVE	2
#define CLEANUP_TIMER_INPROCESS	1
#define CLEANUP_TIMER_INACTIVE	0
	/* Always needs to be protected by tgt_lock. */
	int cleanup_tmr_active;
	vmk_uint16 orig_xid;

#ifdef IOERROR_DEBUGGING
	vmk_Bool printIORelease;
#endif
};

struct io_bdt {
	struct qfle3fCommand *ioRequest;
	struct fcoe_bd_ctx *bd_tbl;
	struct qla_dmamem bd_tbl_dma;
	vmk_uint16 bd_valid;
};

#if 0
#ifdef __FCOE_IF_RESTART_WQ__
struct qfle3f_netdev_work {
	struct work_struct work;
	struct qfle3fHBA *hba;
	unsigned long event;
};
#endif
#endif /* #if 0 */

extern struct qfle3fCommand *qfle3f_commandAlloc(struct qfle3f_rport *);
vmk_uint64 qfle3f_get_wwnn(struct qfle3fHBA *);
vmk_uint64 qfle3f_get_wwpn(struct qfle3fHBA *);

struct qfle3fCommand *qfle3f_elstmAlloc(struct qfle3f_rport *target, int type);
void qfle3f_commandRelease(void *arg);
int qfle3f_queuecommand(vmk_ScsiCommand *sc_cmd,
				void (*done)(vmk_ScsiCommand *));
int qfle3f_sendFirmwareFCoEInitiMessage(struct qfle3fHBA *hba);
int qfle3f_sendFirmwareFCoEDestroyMessage(struct qfle3fHBA *hba);
int qfle3f_sendSessionOffloadRequest(struct qfle3fHBA *hba,
					struct qfle3f_rport *target);
int qfle3f_sendSessionDisableRequest(struct qfle3fHBA *hba,
				    struct qfle3f_rport *target);
int qfle3f_sendSessionDestroyRequest(struct qfle3fHBA *hba,
					struct qfle3f_rport *target);
int qfle3f_mapDoorbell(struct qfle3f_rport *target);
void qfle3f_indicateKCQE(void *context, struct kcqe *kcq[],
					vmk_uint32 num_cqe);
int qfle3f_setupTaskContext(struct qfle3fHBA *hba);
void qfle3f_freeTaskContext(struct qfle3fHBA *hba);
int qfle3f_setupFWResources(struct qfle3fHBA *hba);
void qfle3f_freeFWResources(struct qfle3fHBA *hba);
struct qfle3fCommandManager *qfle3f_commandManagerAlloc(struct qfle3fHBA *hba,
						vmk_uint16 min_xid, vmk_uint16 max_xid);
void qfle3f_commandManagerFree(struct qfle3fCommandManager *cmgr);
void qfle3f_get_link_state(struct qfle3fHBA *hba);
char *qfle3f_getNextReceiveQueueEntry(struct qfle3f_rport *target, vmk_uint8 num_items);
void qfle3f_returnReceiveQueueEntry(struct qfle3f_rport *target, vmk_uint8 num_items);
vmk_uint32 qfle3f_crc(FC_FRAME_HEADER *fp);
int qfle3f_get_paged_crc_eof(vmk_PktHandle *skb, int tlen);
void qfle3f_fill_fc_hdr(FC_FRAME_HEADER *fc_hdr, vmk_uint8 r_ctl,
			vmk_uint32 initiatorPortID, vmk_uint32 did, vmk_uint8 fh_type,
			vmk_uint32 f_ctl, vmk_uint32 param_offset);
int qfle3f_send_rrq(struct qfle3fCommand *abortedIORequest);
int qfle3f_send_adisc(struct qfle3f_rport *target, FC_FRAME_HEADER *fp);
int qfle3f_send_logo(struct qfle3f_rport *target, FC_FRAME_HEADER *fp);
int qfle3f_send_rls(struct qfle3f_rport *target, FC_FRAME_HEADER *fp);
int qfle3f_initiateCleanup(struct qfle3fCommand *ioRequest);
VMK_ReturnStatus qfle3f_initiateABTS(struct qfle3fCommand *ioRequest);
void qfle3f_commandTimerSet(struct qfle3fCommand *ioRequest,
			  vmk_uint32 timer_msec);
VMK_ReturnStatus qfle3f_initMPRequest(struct qfle3fCommand *ioRequest);
void qfle3f_initializeCleanupTask(struct qfle3fCommand *ioRequest,
			      struct fcoe_task_ctx_entry *task,
			      vmk_uint16 orig_xid);
void qfle3f_initializeMPTask(struct qfle3fCommand *ioRequest,
			 struct fcoe_task_ctx_entry *task);
void qfle3f_initializeTask(struct qfle3fCommand *ioRequest,
			     struct fcoe_task_ctx_entry *task);
void qfle3f_addToSQ(struct qfle3f_rport *target, vmk_uint16 xid);
void qfle3f_ringDoorbell(struct qfle3f_rport *target);

VMK_ReturnStatus
qfle3f_scsiCommand(void *clientData, vmk_ScsiCommand *sc_cmd,
	void *deviceData);
VMK_ReturnStatus
qfle3f_scsiTaskMgmt(void *clientData, struct vmk_ScsiTaskMgmt *taskMgmt,
    void *deviceData);
VMK_ReturnStatus qfle3f_ehAbort(struct qfle3fHBA *hba, struct qfle3fFCLun *fclun,
						struct vmk_ScsiTaskMgmt *taskMgmt);
int qfle3f_eh_host_reset(vmk_ScsiCommand *sc_cmd);
int qfle3f_eh_target_reset(vmk_ScsiCommand *sc_cmd);
VMK_ReturnStatus qfle3f_deviceReset(struct qfle3fHBA *hba, struct qfle3fFCLun *fclun,
				struct vmk_ScsiTaskMgmt *taskMgmt);
VMK_ReturnStatus qfle3f_busReset(struct qfle3fHBA *hba, struct qfle3fFCLun *fclun,
						struct vmk_ScsiTaskMgmt *taskMgmt);
void qfle3f_processScsiCommandCompletion(struct qfle3fCommand *ioRequest,
				   struct fcoe_task_ctx_entry *task,
				   vmk_uint8 num_rq);
void qfle3f_processCleanupCompletion(struct qfle3fCommand *ioRequest,
			       struct fcoe_task_ctx_entry *task,
			       vmk_uint8 num_rq);
void qfle3f_processABTSCompletion(struct qfle3fCommand *ioRequest,
			       struct fcoe_task_ctx_entry *task,
			       vmk_uint8 num_rq);
void qfle3f_processTMCompletion(struct qfle3fCommand *ioRequest,
			     struct fcoe_task_ctx_entry *task,
			     vmk_uint8 num_rq);
void qfle3f_process_els_compl(struct qfle3fCommand *els_req,
			      struct fcoe_task_ctx_entry *task,
			      vmk_uint8 num_rq);
void qfle3f_buildFCPCommand(struct qfle3fCommand *ioRequest,
			   FCP_CMND_PAYLOAD *fcp_cmnd);
void qfle3f_flushActiveIOs(struct qfle3f_rport *target);

struct qfle3fFCLun *
	qfle3f_getFCLun(struct qfle3fHBA *hba, struct qfle3f_rport *rport,
		int lun_id);

#if 0
struct fc_seq *qfle3f_elsct_send(struct fc_lport *lport, vmk_uint32 did,
				      FC_FRAME_HEADER *fp, vmk_uint32 op,
				      void (*resp)(struct fc_seq *,
						   FC_FRAME_HEADER *,
						   void *),
				      void *arg, vmk_uint32 timeout);
int qfle3f_processNewMultipleCQ(struct qfle3f_rport *target);
#endif
struct qfle3f_rport *qfle3fSearchTargtByTargetNumber(struct qfle3fHBA *hba,
                                             vmk_uint32 targetNo);
struct qfle3f_rport *qfle3f_targetLookup(struct qfle3fHBA *hba,
									vmk_uint64 wwnn, vmk_uint64 wwpn);
VMK_ReturnStatus qfle3f_queue_scsi_scan(struct qfle3f_rport *target, vmk_Bool incReference);
extern int qfle3f_postIORequest(struct qfle3f_rport *, struct qfle3fCommand *);

void qfle3f_processL2FrameCompletion(struct qfle3f_rport *,
		unsigned char *, vmk_uint32, vmk_uint16);
#if 0
void qfle3f_processL2FrameCompletion(struct qfle3f_rport *target,
				   unsigned char *buf,
				   vmk_uint32 frame_len, vmk_uint16 l2_oxid);
int qfle3f_sendStatRequest(struct qfle3fHBA *hba);
extern int qfle3f_postIORequest(struct qfle3f_rport *,
	struct qfle3fCommand *);
#endif
int qfle3f_bk_send_els_cmd(struct qfle3fHBA *hba);
 VMK_ReturnStatus qfle3f_scsiAdapterSetup(struct qfle3fHBA *hba);
void qfle3f_scsiAdapterDestroy(struct qfle3fHBA *hba);

void qfle3f_uploadTimer(struct qfle3f_rport *target);
void qfle3f_offloadTimer(struct qfle3f_rport *target);
void qfle3f_freeTarget(void *arg);

void qfle3f_wait_for_upload(struct qfle3fHBA *);

extern struct qfle3fHBA *qfle3f_vportLookupByPortID(struct qfle3fHBA *,
		vmk_uint32);


enum ql_fcoe_pcie_link_width {
    QL_FCOE_PCIE_LNK_WIDTH_RESRV    = 0x00,
    QL_FCOE_PCIE_LNK_X1     = 0x01,
    QL_FCOE_PCIE_LNK_X2     = 0x02,
    QL_FCOE_PCIE_LNK_X4     = 0x04,
    QL_FCOE_PCIE_LNK_X8     = 0x08,
    QL_FCOE_PCIE_LNK_X12        = 0x0C,
    QL_FCOE_PCIE_LNK_X16        = 0x10,
    QL_FCOE_PCIE_LNK_X32        = 0x20,
    QL_FCOE_PCIE_LNK_WIDTH_UNKNOWN  = 0xFF,
};

enum ql_fcoe_pci_bus_speed {
    QL_FCOE_PCI_SPEED_33MHz         = 0x00,
    QL_FCOE_PCI_SPEED_66MHz         = 0x01,
    QL_FCOE_PCI_SPEED_66MHz_PCIX        = 0x02,
    QL_FCOE_PCI_SPEED_100MHz_PCIX       = 0x03,
    QL_FCOE_PCI_SPEED_133MHz_PCIX       = 0x04,
    QL_FCOE_PCI_SPEED_66MHz_PCIX_ECC    = 0x05,
    QL_FCOE_PCI_SPEED_100MHz_PCIX_ECC   = 0x06,
    QL_FCOE_PCI_SPEED_133MHz_PCIX_ECC   = 0x07,
    QL_FCOE_PCI_SPEED_66MHz_PCIX_266    = 0x09,
    QL_FCOE_PCI_SPEED_100MHz_PCIX_266   = 0x0a,
    QL_FCOE_PCI_SPEED_133MHz_PCIX_266   = 0x0b,
    QL_FCOE_AGP_UNKNOWN         = 0x0c,
    QL_FCOE_AGP_1X              = 0x0d,
    QL_FCOE_AGP_2X              = 0x0e,
    QL_FCOE_AGP_4X              = 0x0f,
    QL_FCOE_AGP_8X              = 0x10,
    QL_FCOE_PCI_SPEED_66MHz_PCIX_533    = 0x11,
    QL_FCOE_PCI_SPEED_100MHz_PCIX_533   = 0x12,
    QL_FCOE_PCI_SPEED_133MHz_PCIX_533   = 0x13,
    QL_FCOE_PCIE_SPEED_2_5GT        = 0x14,
    QL_FCOE_PCIE_SPEED_5_0GT        = 0x15,
    QL_FCOE_PCIE_SPEED_8_0GT        = 0x16,
    QL_FCOE_PCI_SPEED_UNKNOWN       = 0xff,
};

#define QL_FCOE_PCICFG_LINK_CONTROL     0xbc
#define QL_FCOE_PCICFG_LINK_WIDTH       0x1f00000
#define QL_FCOE_PCICFG_LINK_WIDTH_SHIFT     20
#define QL_FCOE_PCICFG_LINK_SPEED       0xf0000
#define QL_FCOE_PCICFG_LINK_SPEED_SHIFT     16

#if 0
static inline vmk_uint32 qfle3f_remote_port_chkready(struct fc_rport *rport)
{
	int rval;
	struct fc_rport_libfc_priv *rpriv;

	if (!rport || !rport->dd_data)
		return VMK_SCSI_HOST_RETRY;

	if (!(rval = fc_remote_port_chkready(rport))) {
		rpriv = (struct fc_rport_libfc_priv *)rport->dd_data;

		switch (rpriv->rp_state) {
		case RPORT_EV_READY:
			break;

		case RPORT_EV_FAILED:
			rval = VMK_SCSI_HOST_RETRY;
			break;

		case RPORT_EV_LOGO:
		case RPORT_EV_STOP:
		default:
			rval = VMK_SCSI_HOST_NO_CONNECT;
			break;
		}
	}

	return rval;
}

int qfle3f_proc_info(struct Scsi_Host *shost, char *buffer, char **start,
    vmk_uint64 offset, int length, int func);
#endif

/*
 * HBA attribute types.
 */
#define FDMI_HBA_ATTR_COUNT			0xa
#define FDMI2_HBA_ATTR_COUNT			0x12
#define FDMI_HBA_NODE_NAME			1
#define FDMI_HBA_MANUFACTURER			2
#define FDMI_HBA_SERIAL_NUMBER			3
#define FDMI_HBA_MODEL				4
#define FDMI_HBA_MODEL_DESCRIPTION		5
#define FDMI_HBA_HARDWARE_VERSION		6
#define FDMI_HBA_DRIVER_VERSION			7
#define FDMI_HBA_OPTION_ROM_VERSION		8
#define FDMI_HBA_FIRMWARE_VERSION		9
#define FDMI_HBA_OS_NAME_AND_VERSION		0xa
#define FDMI_HBA_MAXIMUM_CT_PAYLOAD_LENGTH	0xb
#define FDMI_HBA_NODE_SYM_NAME			0xc
#define FDMI_HBA_VENDOR_SPECIFIC_INFO		0xd
#define FDMI_HBA_NO_OF_PORTS			0xe
#define FDMI_HBA_FABRIC_NAME			0xf
#define FDMI_HBA_BOOT_BIOS_NAME			0x10
#define FDMI_HBA_BOOT_BIOS_STATE		0x11
#define FDMI_HBA_VENDOR_IDENTIFIER		0xE0

struct ct_fdmi_hba_attr {
	vmk_uint16 type;
	vmk_uint16 len;
	union {
		char nodeName[WWN_SIZE];
		char manufacturer[64];
		char serial_num[64];
		char model[256];
		char model_desc[256];
		char hw_version[256];
		char driver_version[256];
		char orom_version[256];
		char fw_version[256];
		char os_version[256];
		vmk_uint32 max_ct_len;
		/* FDMI - 2 Attributes */
		char node_sym_name[256];
		vmk_uint32 vendor_info;
		vmk_uint32 no_of_ports;
		char fabric_name[WWN_SIZE];
		char boot_bios_name[256];
		vmk_uint32 boot_bios_state;
		vmk_uint8 vendor_identifier[8];
	} a;
};

struct ct_fdmi_hba_attributes {
	vmk_uint32 count;
	struct ct_fdmi_hba_attr entry[FDMI2_HBA_ATTR_COUNT];
};


/*
 * Max PCI info string size.
 */
#define MAX_PCI_INFO_SIZE	30

/*
 * Port attribute types.
 */
#define FDMI_PORT_ATTR_COUNT                    0x6
#define FDMI2_PORT_ATTR_COUNT			        0x10
#define FDMI2_SMARTSAN_PORT_ATTR_COUNT          0x18
#define FDMI_PORT_FC4_TYPES                     0x1
#define FDMI_PORT_SUPPORT_SPEED                 0x2
#define FDMI_PORT_CURRENT_SPEED                 0x3
#define FDMI_PORT_MAX_FRAME_SIZE                0x4
#define FDMI_PORT_OS_DEVICE_NAME                0x5
#define FDMI_PORT_HOST_NAME                     0x6
#define FDMI_PORT_NODE_NAME		                0x7
#define FDMI_PORT_PORT_NAME		                0x8
#define FDMI_PORT_SYM_NAME		                0x9
#define FDMI_PORT_TYPE			                0xa
#define FDMI_PORT_SUPPORTED_COS		            0xb
#define FDMI_PORT_FABRIC_NAME		            0xc
#define FDMI_PORT_ACT_FC4_TYPE		            0xd
#define FDMI_PORT_STATE			                0x101
#define FDMI_PORT_NUM_OF_PORTS		            0x102
#define FDMI_PORT_PORT_IDENTIFIER	            0x103
#define FDMI_PORT_SMARTSAN_SERVICE_CATEGORY     0xF100
#define FDMI_PORT_SMARTSAN_GUID                 0xF101
#define FDMI_PORT_SMARTSAN_VERSION              0xF102
#define FDMI_PORT_SMARTSAN_PRODUCT_NAME         0xF103
#define FDMI_PORT_SMARTSAN_PORT_INFO            0xF104
#define FDMI_PORT_SMARTSAN_QOS_SUPPORT          0xF105
#define FDMI_PORT_SMARTSAN_SECURITY_SUPPORT	    0xF106
#define FDMI_PORT_SMARTSAN_CONN_TARGET_PORTS    0xF107

#define FDMI_PORT_SPEED_1GB		0x1
#define FDMI_PORT_SPEED_2GB		0x2
#define FDMI_PORT_SPEED_10GB		0x4
#define FDMI_PORT_SPEED_4GB		0x8
#define FDMI_PORT_SPEED_8GB		0x10
#define FDMI_PORT_SPEED_16GB		0x20
#define FDMI_PORT_SPEED_32GB		0x40
#define FDMI_PORT_SPEED_UNKNOWN		0x8000

// Port state parameter options
#define HBA_PORTSTATE_UNKNOWN 1 /* Unknown */
#define HBA_PORTSTATE_ONLINE 2 /* Fully Operational */
#define HBA_PORTSTATE_OFFLINE 3 /* User Offline */
#define HBA_PORTSTATE_BYPASSED 4 /* Bypassed */
#define HBA_PORTSTATE_DIAGNOSTICS 5 /* In diagnostics mode */
#define HBA_PORTSTATE_LINKDOWN 6 /* Link Down */
#define HBA_PORTSTATE_ERROR 7 /* Port Error */
#define HBA_PORTSTATE_LOOPBACK 8 /* Loopback */
#define HBA_PORTSTATE_DEGRADED 9 /* Degraded, but Operational mode */

/*
 * Class of service for Port Attributes.
 * In accordance with the FC-GS-3 specs.
 */
#define BNX_FC_CLASS_UNSPECIFIED		0x00
#define BNX_FC_CLASS_2		0x04
#define BNX_FC_CLASS_3		0x08
#define BNX_FC_CLASS_2_3	0x0C

#define NS_NX_PORT_TYPE			0x7F

struct ct_fdmi_port_attr {
	vmk_uint16 type;
	vmk_uint16 len;
	union {
		vmk_uint8 fc4_types[32];
		vmk_uint32 sup_speed;
		vmk_uint32 cur_speed;
		vmk_uint32 max_frame_size;
		char os_dev_name[32];
		char host_name[32];
		/* FDMI-2 Attributes */
		vmk_uint8 nodeName[WWN_SIZE];
		vmk_uint8 portName[WWN_SIZE];
		vmk_uint8 port_sym_name[256];
		vmk_uint32 portType;
		vmk_uint32 supported_cos;
		vmk_uint8 port_fabric_name[WWN_SIZE];
		vmk_uint8 port_act_fc4_type[32];
		vmk_uint32 portState;
		vmk_uint32 num_discovered_ports;
		vmk_uint8  targetPortIDentifier[4];
		/* SMARTSAN related port attributes */
		char smart_san_service_category[256];
		vmk_uint8 smart_san_guid[16];
		vmk_uint8 smart_san_version[256];
		vmk_uint8 smart_san_product_name[16];
		vmk_uint32 smart_san_port_info;
		vmk_uint32 smart_san_qos_support;
		vmk_uint32 smart_san_security_support;
		/* Length could be 8-256. */
		vmk_uint8 smart_san_connected_target_ports[8];
	} a;
};

/*
 * Port Attribute Block.
 */
struct ct_fdmi_port_attributes {
	vmk_uint32 count;
	struct ct_fdmi_port_attr entry[FDMI2_PORT_ATTR_COUNT];
};

#define RHBA_CMD	0x200
#define RHBA_RSP_SIZE	16

#define RPA_CMD		0x211
#define RPA_RSP_SIZE	16

/* CT command header -- request/response common fields */
struct ct_cmd_hdr {
	vmk_uint8 revision;
	vmk_uint8 in_id[3];
	vmk_uint8 gs_type;
	vmk_uint8 gs_subtype;
	vmk_uint8 options;
	vmk_uint8 reserved;
};

#define MAX_CT_REQ_SIZE		0x500

/* CT command request */
struct ct_sns_req {
	struct ct_cmd_hdr header;
	vmk_uint16 command;
	vmk_uint16 max_rsp_size;
	vmk_uint8 fragment_id;
	vmk_uint8 reserved[3];

	union {
		struct {
			vmk_uint8 hba_identifier[8];
			vmk_uint32 entry_count;
			vmk_uint8 portName[8];
			struct ct_fdmi_hba_attributes attrs;
		} rhba;

		struct {
			vmk_uint8 portName[8];
			struct ct_fdmi_port_attributes attrs;
		} rpa;
	} req;
};

/* CT command response header */
struct ct_rsp_hdr {
	struct ct_cmd_hdr header;
	vmk_uint16 response;
	vmk_uint16 reinitiatorPortIDual;
	vmk_uint8 fragment_id;
	vmk_uint8 reason_code;
	vmk_uint8 explanation_code;
	vmk_uint8 vendor_unique;
};

struct qfle3fDriverInfo_t {
	vmk_ModuleID moduleID;
	vmk_Name driverName;
	vmk_BitVector *hostInstanceMap;
    struct qfle3fHBA *hbaArray[1024];
	vmk_ListLinks qfle3fHostList;
	vmk_uint32 host_count;

	vmk_HeapID moduleDMAHeapID;
	vmk_HeapID moduleHeapID;
	vmk_HeapID module_fw_dump_heap_id;

	vmk_Driver qfle3fDriver;
	vmk_LockDomainID  lockDomain;  /* Lock Domain */
	vmk_TimerQueue timerQueue;
	vmk_MgmtHandle kvMgmtModuleParm;
	vmk_DumpFileHandle dumpHandler;

    vmk_Semaphore drvLock;

	vmk_TimerQueue delayedTQ;
};

extern struct qfle3fDriverInfo_t qfle3fDriverInfo;
extern vmk_Bool checkStatReqComplFlag(void *);

struct qfle3fHBA *qfle3f_interface_create(struct cnic_dev *cnic, vmk_uint8 is_npiv);
VMK_ReturnStatus qfle3f_interface_setup(struct qfle3fHBA *hba);
void qfle3f_interface_destroy(struct qfle3fHBA *hba);
int qfle3f_l2_rcv_thread(void *arg);
struct qfle3fHBA *qfle3f_find_hba_for_cnic(struct cnic_dev *cnic);

/* SV: Brought over from scsi_transposrt_fc.h --start-- */
struct qfc_rtargetPortIDentifiers {
    vmk_uint64 nodeName;
    vmk_uint64 portName;
    vmk_uint32 targetPortID;
    vmk_uint32 roles;
};
/* SV: Brought over from scsi_transposrt_fc.h --end-- */

struct qfle3f_rport *qfle3f_remotePortAdd(void *,
						struct ql_fcoe_session *);
void qfle3f_remotePortDelete(struct qfle3f_rport *rport);
void qfle3f_rportEventHandler(void *,
				struct ql_fcoe_session *Sess,
				enum ql_fcoe_rport_event event);

struct fcoe_template {
	char                 name[32];
	vmk_ModuleID         module_id;

	int                  (* fcoe_create) (struct ql_fcoe_adapter *);
	int                  (* fcoe_destroy) (struct ql_fcoe_adapter *);
	int                  (* fcoe_wakeup) (struct ql_fcoe_adapter *);
	int                  (* fcoe_recv) (vmk_PktHandle *, struct ql_fcoe_adapter *);
	int                  (* fip_recv) (vmk_PktHandle *, struct ql_fcoe_adapter *);
};

VMK_ReturnStatus qfle3f_rx_cb(struct cnic_dev *cdev, vmk_PktHandle *pkt);
void qfle3fInitFcoeAdapter(vmk_FcoeAdapter *qlaFcoeAdapter);
struct qfle3f_rport *
qfle3f_findTargetByTargetID(struct qfle3fHBA *hba,
                                int targetID,
                                vmk_Bool checkIfTargetIsOnline);
struct qfle3f_rport *
qfle3f_findTargetByConnectionID(struct qfle3fHBA *hba,
								int conn_id,
								vmk_Bool checkIfTargetIsOnline);
void qfle3fKeyValueInitPerHBA(struct qfle3fHBA *hba);
VMK_ReturnStatus qfle3fKeyValueInit();

int qfle3f_sendStatRequest(struct qfle3fHBA *hba);
void qfle3f_get_host_stats(struct qfle3fHBA *hba);

void qfle3f_fw_destroy(struct qfle3fHBA *hba);
void qfle3f_stop(struct qfle3fHBA *hba);

VMK_ReturnStatus qfle3f_scheduleDevlossTimer(struct qfle3f_rport *);
VMK_ReturnStatus qfle3f_cancelDevlossTimer(struct qfle3f_rport *, vmk_Bool);

int qfle3f_send_els_logo(struct qfle3f_rport *target, vmk_PktHandle *pkt);
// For debugging purposes
void qfle3f_printBuffer(struct qfle3fHBA *hba, vmk_uint8 *b,
                    vmk_uint32 size, char *printBanner);
void qfle3f_addConn(struct qfle3fHBA *hba, struct qfle3f_rport *target);
void qfle3f_uploadSession(struct qfle3fHBA *hba, struct qfle3f_rport *target);
void qfle3f_removeConn(struct qfle3fHBA *hba, struct qfle3f_rport *target);

void qfle3f_vport_interface_destroy(struct qfle3fHBA *vhba);
#endif
