/* geneTree.c was originally generated by the autoSql program, which also 
 * generated geneTree.h and geneTree.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "geneTree.h"


void geneTreeStaticLoad(char **row, struct geneTree *ret)
/* Load a row from geneTree table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->tree = row[1];
}

struct geneTree *geneTreeLoad(char **row)
/* Load a geneTree from row fetched with select * from geneTree
 * from database.  Dispose of this with geneTreeFree(). */
{
struct geneTree *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->tree = cloneString(row[1]);
return ret;
}

struct geneTree *geneTreeLoadAll(char *fileName) 
/* Load all geneTree from a whitespace-separated file.
 * Dispose of this with geneTreeFreeList(). */
{
struct geneTree *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = geneTreeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct geneTree *geneTreeLoadAllByChar(char *fileName, char chopper) 
/* Load all geneTree from a chopper separated file.
 * Dispose of this with geneTreeFreeList(). */
{
struct geneTree *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = geneTreeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct geneTree *geneTreeCommaIn(char **pS, struct geneTree *ret)
/* Create a geneTree out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new geneTree */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->tree = sqlStringComma(&s);
*pS = s;
return ret;
}

void geneTreeFree(struct geneTree **pEl)
/* Free a single dynamically allocated geneTree such as created
 * with geneTreeLoad(). */
{
struct geneTree *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->tree);
freez(pEl);
}

void geneTreeFreeList(struct geneTree **pList)
/* Free a list of dynamically allocated geneTree's */
{
struct geneTree *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    geneTreeFree(&el);
    }
*pList = NULL;
}

void geneTreeOutput(struct geneTree *el, FILE *f, char sep, char lastSep) 
/* Print out geneTree.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tree);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

