/* bgiGeneInfo.h was originally generated by the autoSql program, which also 
 * generated bgiGeneInfo.c and bgiGeneInfo.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BGIGENEINFO_H
#define BGIGENEINFO_H

#define BGIGENEINFO_NUM_COLS 4

struct bgiGeneInfo
/* Beijing Genomics Institute Genes track additional information */
    {
    struct bgiGeneInfo *next;  /* Next in singly linked list. */
    char *name;	/* BGI annotation gene name */
    char *source;	/* Source of gene annotation */
    char *go;	/* comma-sep list of GO numeric IDs */
    char *ipr;	/* semicolon-sep list of IPR numeric IDs and comments */
    };

void bgiGeneInfoStaticLoad(char **row, struct bgiGeneInfo *ret);
/* Load a row from bgiGeneInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bgiGeneInfo *bgiGeneInfoLoad(char **row);
/* Load a bgiGeneInfo from row fetched with select * from bgiGeneInfo
 * from database.  Dispose of this with bgiGeneInfoFree(). */

struct bgiGeneInfo *bgiGeneInfoLoadAll(char *fileName);
/* Load all bgiGeneInfo from whitespace-separated file.
 * Dispose of this with bgiGeneInfoFreeList(). */

struct bgiGeneInfo *bgiGeneInfoLoadAllByChar(char *fileName, char chopper);
/* Load all bgiGeneInfo from chopper separated file.
 * Dispose of this with bgiGeneInfoFreeList(). */

#define bgiGeneInfoLoadAllByTab(a) bgiGeneInfoLoadAllByChar(a, '\t');
/* Load all bgiGeneInfo from tab separated file.
 * Dispose of this with bgiGeneInfoFreeList(). */

struct bgiGeneInfo *bgiGeneInfoCommaIn(char **pS, struct bgiGeneInfo *ret);
/* Create a bgiGeneInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bgiGeneInfo */

void bgiGeneInfoFree(struct bgiGeneInfo **pEl);
/* Free a single dynamically allocated bgiGeneInfo such as created
 * with bgiGeneInfoLoad(). */

void bgiGeneInfoFreeList(struct bgiGeneInfo **pList);
/* Free a list of dynamically allocated bgiGeneInfo's */

void bgiGeneInfoOutput(struct bgiGeneInfo *el, FILE *f, char sep, char lastSep);
/* Print out bgiGeneInfo.  Separate fields with sep. Follow last field with lastSep. */

#define bgiGeneInfoTabOut(el,f) bgiGeneInfoOutput(el,f,'\t','\n');
/* Print out bgiGeneInfo as a line in a tab-separated file. */

#define bgiGeneInfoCommaOut(el,f) bgiGeneInfoOutput(el,f,',',',');
/* Print out bgiGeneInfo as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* BGIGENEINFO_H */

